# Nanoparticle classifcation, physicochemical properties, characterization, and applications: a comprehensive review for biologists

Nadeem Joudeh and Dirk Linke\*

# Abstract

Interest in nanomaterials and especially nanoparticles has exploded in the past decades primarily due to their novel or enhanced physical and chemical properties compared to bulk material. These extraordinary properties have created a multitude of innovative applications in the felds of medicine and pharma, electronics, agriculture, chemical catalysis, food industry, and many others. More recently, nanoparticles are also being synthesized ‘biologically’ through the use of plant- or microorganism-mediated processes, as an environmentally friendly alternative to the expensive, energy-intensive, and potentially toxic physical and chemical synthesis methods. This transdisciplinary approach to nanoparticle synthesis requires that biologists and biotechnologists understand and learn to use the complex methodology needed to properly characterize these processes. This review targets a bio-oriented audience and summarizes the physico–chemical properties of nanoparticles, and methods used for their characterization. It highlights why nanomaterials are diferent compared to micro- or bulk materials. We try to provide a comprehensive overview of the diferent classes of nanoparticles and their novel or enhanced physicochemical properties including mechanical, thermal, magnetic, electronic, optical, and catalytic properties. A comprehensive list of the common methods and techniques used for the characterization and analysis of these properties is presented together with a large list of examples for biogenic nanoparticles that have been previously synthesized and characterized, including their application in the felds of medicine, electronics, agriculture, and food production. We hope that this makes the many diferent methods more accessible to the readers, and to help with identifying the proper methodology for any given nanoscience problem.

Keywords: Nanomaterials, Metal nanoparticles, Biogenic nanoparticles, Bionanoparticles, Nanobiotechnology, Characterization of nanomaterials

# Background

# Nano etymology

Te prefx nano is derived from the Greek word nanos, “a dwarf”. In 1947, at the 14th conference of the International Union of Pure and Applied Chemistry (IUPAC), the prefx nano was ofcially adopted to describe the one-billionth part $( 1 0 ^ { - 9 } )$ of a unit1 . In scientifc literature, the prefx nano has been adopted as a popular label in many felds of modern science to describe small entities and processes. Tese terms include, but are not limited to nanoscience, nanotechnology, nanorobots, nanomagnets, nanoelectronics, nanoencapsulation, etc. [1]. In all of these cases, the prefx nano is used to describe “very small” entities or processes, most often at actual nanometer scale.

# Defnitions

Nanoscience is a branch of science that comprises the study of properties of matter at the nanoscale, and particularly focuses on the unique, size-dependent properties of solid-state materials [2]. Nanotechnology is the branch that comprises the synthesis, engineering, and utilization of materials whose size ranges from 1 to $1 0 0 ~ \mathrm { { n m } }$ , known as nanomaterials [3]. Te birth of nanoscience and nanotechnology concepts is usually linked to the famous lecture of Nobel laureate Richard Feynman at the 1959 meeting of the American Physical Society, ‘‘Tere’s Plenty of Room at the Bottom’’ [4]. However, the use of nanotechnology and nanomaterials goes back in history long before that.

# History of nanotechnology

Long before the era of nanotechnology, people were unknowingly coming across various nanosized objects and using nano-level processes. In ancient Egypt, dyeing hair in black was common and was for a long time believed to be based on plant products such as henna [5]. However, recent research on hair samples from ancient Egyptian burial sites showed that hair was dyed with paste from lime, lead oxide, and water [6]. In this dyeing process, galenite (lead sulfde, PbS) nanoparticles are formed. Te ancient Egyptians were able to make the dyeing paste react with sulfur (part of hair keratin) and produce small PbS nanoparticles which provided even and steady dyeing.

Probably the most famous example for the ancient use of nanotechnology is the Lycurgus Cup (fourth century CE). Tis ancient roman cup possesses unusual optical properties; it changes its color based on the location of the light source. In natural light, the cup is green, but when it is illuminated from within (with a candle), it becomes red. Te recent analysis of this cup showed that it contains $5 0 { - } 1 0 0 ~ \mathrm { n m }$ Au and Ag nanoparticles [7], which are responsible for the unusual coloring of the cup through the efects of plasmon excitation of electrons [8]. Te ancient use of nanotechnology does not stop here, in fact, there is evidence for the early use of nanotechnology processes in Mesopotamia, Ancient India, and the Maya [9, 10].

# Why nanomaterials are diferent

Today, due to their unique properties, nanomaterials are used in a wide range of applications, such as catalysis, water treatment, energy storage, medicine, agriculture, etc. [11–13]. Two main factors cause nanomaterials to behave signifcantly diferently than the same materials at larger dimensions: surface efects and quantum efects [14]. Tese factors make nanomaterials exhibit enhanced or novel mechanical, thermal, magnetic, electronic, optical, and catalytic properties [1, 15, 16].

Nanomaterials have diferent surface efects compared to micromaterials or bulk materials, mainly due to three reasons; (a) dispersed nanomaterials have a very large surface area and high particle number per mass unit, (b) the fraction of atoms at the surface in nanomaterials is increased, and (c) the atoms situated at the surface in nanomaterials have fewer direct neighbors [1, 14]. As a consequence of each of these diferences, the chemical and physical properties of nanomaterials change compared to their larger-dimension counterparts. For instance, having fewer direct neighbor atoms for the atoms situated at the surface results in lowering the binding energy per atom for nanomaterials. Tis change directly afects the melting temperature of nanomaterials following the Gibbs–Tomson equation, e.g., the melting point of $2 . 5 \ \mathrm { n m }$ gold nanoparticles is 407 degrees lower than the melting point of bulk gold [14]. Larger surface areas and larger surface-to-volume ratios generally increases the reactivity of nanomaterials due to the larger reaction surface [1], as well as resulting in signifcant efects of surface properties on their structure [17]. Te dispersity of nanomaterials is a key factor for the surface efects. Te strong attractive interactions between particles can result in the agglomeration and aggregation of nanomaterials, which negatively afects their surface area and their nanoscale properties [18]. Agglomeration can be prevented by increasing the zeta potential of nanomaterials (increasing the repulsive force) [19], optimizing the degree of hydrophilicity/hydrophobicity of the nanomaterial, or by optimizing the pH and the ionic strength of the suspension medium [20].

Nanomaterials display distinct size-dependent properties in the $1 { - } 1 0 0 ~ \mathrm { n m }$ range where quantum phenomena are involved. When the material radius approaches the asymptotic exciton Bohr radius (the separation distance between the electron and hole), the infuence of quantum confnement becomes apparent [17]. In other words, by shrinking the size of the material, quantum efects become more pronounced, and nanomaterials become quantal. Tose quantum structures are physical structures where all the charge carriers (electrons and holes) are confned within the physical dimensions [21]. As a result of quantum confnement efects, for instance, some non-magnetic materials in bulk such as palladium, platinum, and gold become magnetic in the nanoscale [14]. Quantum confnement can also result in signifcant changes in electron afnity or the ability to accept or donate electrical charges, which is directly refected on the catalytic properties of the material. For example, the catalytic activity of cationic platinum clusters in $\mathrm { N } _ { 2 } \mathrm { O }$ decomposition is dictated by the number of atoms in the cluster. 6–9, 11, 12, 15, and 20 atom-containing clusters are very reactive, while clusters with 10, 13, 14, and 19 atoms have low reactivity [14].

![](images/f398b41d71b6ea06ae69be5de4a5b6a306e6121e0cc1743b98e1f84a00d3c496.jpg)  
Fig. 1 Nanomaterials classifcation based on dimensionality

confned to the nanoscale in any dimension. Tis class contains bulk powders, dispersions of nanoparticles, arrays of nanowires and nanotubes, etc.

# Classifcation of nanomaterials

Te key elements of nanotechnology are the nanomaterials. Nanomaterials are defned as materials where at least one of their dimensions is in the nanoscale, i.e. smaller than $1 0 0 \mathrm { n m }$ [22]. Based on their dimensionalities, nanomaterials are placed into four diferent classes, summarized in Fig. 1.

(1) Zero-dimensional nanomaterials (0-D): the nanomaterials in this class have all their three dimensions in the nanoscale range. Examples are quantum dots, fullerenes, and nanoparticles.   
(2) One-dimensional nanomaterials (1-D): the nanomaterials in this class have one dimension outside the nanoscale. Examples are nanotubes, nanofbers, nanorods, nanowires, and nanohorns.   
(3) Two-dimensional nanomaterials (2-D): the nanomaterials in this class have two dimensions outside the nanoscale. Examples are nanosheets, nanoflms, and nanolayers.   
(4) Tree-dimensional nanomaterials (3-D) or bulk nanomaterials: in this class the materials are not

# Nanoparticles (NPs)

Te International Organization for Standardization (ISO) defnes nanoparticles as nano-objects with all external dimensions in the nanoscale, where the lengths of the longest and the shortest axes of the nano-object do not difer signifcantly. If the dimensions difer signifcantly (typically by more than three times), terms such as nanofbers or nanoplates maybe preferred to the term $\mathrm { N P s ^ { 2 } }$ .

NPs can be of diferent shapes, sizes, and structures. Tey can be spherical, cylindrical, conical, tubular, hollow core, spiral, etc., or irregular [23]. Te size of NPs can be anywhere from 1 to $1 0 0 \mathrm { n m }$ . If the size of NPs gets lower than $1 \ \mathrm { n m }$ , the term atom clusters is usually preferred. NPs can be crystalline with single or multi-crystal solids, or amorphous. NPs can be either loose or agglomerated [24].

NPs can be uniform, or can be composed of several layers. In the latter case, the layers often are: (a) Te surface layer, which usually consists of a variety of small molecules, metal ions, surfactants, or polymers. (b) Te shell layer, which is made of a chemically diferent material from the core layer. (c) Te core layer, which is the central portion of the NP [25].

![](images/0f1f17273a52c06b8da772276b885a9786961e4905c6b163c14fe232b1aa540a.jpg)  
Fig. 3 Diferent types of carbon-based NPs. A $C _ { 6 0 }$ fullerene; B carbon black NPs; and C carbon quantum dots

diferent parameters that determine the potential feld of application of organic NPs, e.g., composition, surface morphology, stability, carrying capacity, etc. Today, organic NPs are mostly used in the biomedical feld in targeted drug delivery [23] and cancer therapy [28].

# Classifcation of NPs

Based on their composition, NPs are generally placed into three classes: organic, carbon-based, and inorganic [23].

# Organic NPs

Tis class comprises NPs that are made of proteins, carbohydrates, lipids, polymers, or any other organic compounds [26]. Te most prominent examples of this class are dendrimers, liposomes, micelles, and protein complexes such as ferritin (shown in Fig.  2). Tese NPs are typically non-toxic, bio-degradable, and can in some cases, e.g., for liposomes, have a hollow core. Organic NPs are sensitive to thermal and electromagnetic radiation such as heat and light [23]. In addition, they are often formed by non-covalent intermolecular interactions, which makes them more labile in nature and ofers a route for clearance from the body [27]. Tere are

# Carbon‑based NPs

Tis class comprises NPs that are made solely from carbon atoms [23]. Famous examples of this class are fullerenes, carbon black NPs, and carbon quantum dots (shown in Fig.  3). Fullerenes are carbon molecules that are characterized by a symmetrical closed-cage structure. $C _ { 6 0 }$ fullerenes consist of 60 carbon atoms arranged in the shape of a soccer ball [29], but also other types of fullerenes such as $\mathrm { C } _ { 7 0 }$ and $\mathrm { C } _ { 5 4 0 }$ fullerenes have been described [30]. Carbon black NPs are grape-like aggregates of highly fused spherical particles [31]. Carbon quantum dots consist of discrete, quasi-spherical carbon NPs with sizes below $1 0 ~ \mathrm { { n m } }$ [32]. Carbon-based NPs unite the distinctive properties of $\mathsf { s p } ^ { 2 }$ -hybridized carbon bonds with the unusual physicochemical properties at the nanoscale. Due to their unique electrical conductivity, high strength, electron afnity, optical, thermal, and sorption properties [25, 33], carbon-based NPs are used in a wide range of application such as drug delivery [34], energy storage [35], bioimaging [36], photovoltaic devices, and environmental sensing applications to monitor microbial ecology or to detect microbial pathogens [33]. Nanodiamonds and carbon nano onions are more complex, carbonbased NPs. Due to their characteristic low toxicity and biocompatibility, they are used in drug delivery and tissue engineering applications [37, 38].

# Inorganic NPs

Tis class comprises NPs that not made of carbon or organic materials. Te typical examples of this class are metal, ceramic, and semiconductor NPs. Metal NPs are purely made of metal precursors, they can be monometallic, bimetallic [39], or polymetallic [40]. Bimetallic NPs can be made from alloys or formed in diferent layers (core–shell) [39]. Due to the localized surface plasmon resonance characteristics, these NPs possess unique optical and electricals properties [25]. In addition, some metal NPs also possess unique thermal, magnetic, and biological properties [23]. Tis makes them increasingly important materials for the development of nanodevices that can be used in numerous physical, chemical, biological, biomedical, and pharmaceutical applications [41, 42] (these applications are discussed in detail later in the applications section of the review). In present days, the size-, shape-, and facet-controlled synthesis of metal NPs is important for creating cutting-edge materials [43].

Semiconductor NPs are made of semiconductor materials, which possess properties between metals and non-metals. Tese NPs possess unique wide bandgaps and show signifcant alteration in their properties with bandgap tuning compared to bulk semiconductor materials [25]. As a result, these NPs are important materials in photocatalysis, optic, and electronic devices [44, 45]. Ceramic NPs are inorganic solids made of carbonates, carbides, phosphates, and oxides of metals and metalloids, such as titanium and calcium [46]. Tey are usually synthesized via heat and successive cooling and they can be found in amorphous, polycrystalline, dense, porous or hollow forms [25]. Tey are mainly used in biomedical applications due to their high stability and high load capacity [47]. Nevertheless, they are also used in other applications such as catalysis, degradation of dyes, photonics and optoelectronics [46, 48].

# Physicochemical properties of NPs

As mentioned earlier, NPs can be used in a long list of applications due to their unique physical and chemical properties that do not exist in their larger-dimension counterparts of the same materials. Te following sections summarize the most import physicochemical properties that are changing on the nanoscale.

# Mechanical properties

Mechanical properties refer to the mechanical characteristics of a material under diferent conditions, environments, and various external forces. As for traditional materials, the mechanical properties of nanomaterials generally consist of ten parts: strength, brittleness, hardness, toughness, fatigue strength, plasticity, elasticity, ductility, rigidity, and yield stress [49]. Most inorganic, non-metallic materials are brittle materials and do not have signifcant toughness, plasticity, elasticity, or ductility properties. Organic materials on the other hand, are fexible materials and do not necessarily have brittleness and rigidity properties.

Due to surface and quantum efects, NPs display different mechanical properties compared to bulk materials [49]. For example, conventional FeAl powder which is composed of microparticles (larger than $4 \mu \mathrm { m } ,$ ), is brittle, while ultrafne FeAl alloy powder displays a good combination of strength and ductility as well as enhanced plasticity [50]. Tese new properties are believed to arise due to the diverse interaction forces between NPs or between them and a surface. Te most important interaction forces involved are van der Waals forces, which consist of three parts, Keesom force, Debye force, and London force [51–53]. Other relevant interaction forces are electrostatic and electrical double layer forces, normal and lateral capillary forces, solvation, structural, and hydration forces [54].

Tere are diferent theories on how the interaction forces between NPs give them new mechanical properties, such as the DLVO (Derjaguin–Landau–Verwey– Overbeek) theory, JKR (Johnson–Kendall–Roberts) theory, and DMT (Derjaguin–Muller–Toporov) theory. Te DLVO theory combines the efects of van der Waals attraction and electrostatic repulsion to describe the stability of colloidal dispersions [54]. Tis theory can explain many phenomena in colloidal science, such as the adsorption and the aggregation of NPs in aqueous solutions and the force between charged surfaces interacting through a liquid medium [55, 56]. Nevertheless, the DLVO theory is inadequate for the colloidal properties in the aggregated state [54].

When the size of objects decreases to the nanoscale, the surface forces become a major player in their adhesion, contact, and deformation behaviors. Te JRK theory is applicable to easily deformable, large bodies with high surface energies, where it describes the domination of surface interactions by strong, short-range adhesion forces. In contrast to this, the DMT theory is applicable to very small and hard bodies with low surface energies, where it describes the adhesion being caused by the presence of weak, long-range attractive forces. Although the DLVO, JKR and DMT theories have been widely used to describe and study the mechanical properties of NPs [57, 58], it is still a matter of debate whether or not continuum mechanics can be used to describe a particle or collection of particles at the nanometer scale [54].

# Thermal properties

Heat transfer in NPs primarily depends on energy conduction due to electrons as well as photons (lattice vibration) and the scattering efects that accompany both [59]. Te major components of thermal properties of a material are thermal conductivity, thermoelectric power, heat capacity, and thermal stability [59, 60].

NP size has a direct impact on electrical and thermal conductivity of NPs [60]. As the NP size decreases, the ratio of particle surface area respective to its volume increases hyperbolically [60]. Since the conduction of electrons is one of the two main ways in which heat is transferred, the higher surface-to-volume ratio in NPs provides higher number of electrons for heat transfer compared to bulk materials [61]. Moreover, thermal conductivity in NPs is also promoted by microconvection, which results from the Brownian motion of NPs [62]. Nevertheless, this phenomenon only happens when solid NPs are dispersed in a liquid (generating a Nanofuid) [63]. As an example, the addition of Cu NPs to ethylene glycol enhances the thermal conductivity of the fuid up to $4 0 \%$ [64].

Te thermoelectric power of a material depends on its Seebeck coefcient and electrical conductivity $( P = S ^ { 2 } \sigma$ , where $\mathrm { P }$ is thermoelectric power, S is the Seebeck coefcient, and $\sigma$ is the electrical conductivity). Te scattering of NPs in bulk materials (doping) is known to enhance the thermoelectric power factor [65]. Tis enhancement could come from the enhancement of the Seebeck coeffcient or the enhancement of electrical conductivity. Te embedding of size-controlled NPs in bulk thermoelectric materials helps to reduce the lattice thermal conductivity and enhances the Seebeck coefcient due to electron energy fltering [66, 67]. Generally, the enhancement of electrical conductivity is accompanied by the reduction of the Seebeck coefcient and vice versa [65] However, the doping of InGaAlAs material with $2 { - } 3 \ \mathrm { n m }$ Er NPs resulted in the signifcant increase of thermoelectric power of the material through the enhancement of the conductivity while keeping the Seebeck coefcient unchanged [65]. Depending on NP size, volume fraction, and band ofset, a NP-doped sample can either enhance or suppress the electrical conductivity in comparison with undoped bulk sample.

Experimental studies have shown that the heat capacity of NPs exceeds the values of analogous bulk materials by up to $1 0 \%$ [68], e.g. in the case of $\mathrm { { A l } _ { 2 } \mathrm { { O } _ { 3 } } }$ and $\mathrm { S i O } _ { 2 }$ NPs [69, 70]. Te major contribution to heat capacity at ambient temperatures is determined by the vibration degrees of freedom, i.e., the peculiarities of phonon spectra (vibrational energy that arises from oscillating atoms within a crystal) are responsible for the anomalous behavior of heat capacity of NPs [68]. NPs usually exhibit a signifcant decrease in melting temperature compared to their analogous bulk materials [71]. Te main reason for this phenomenon is that the liquid/vapor interface energy is generally lower than the average solid/vapor interface energy [72]. When the particle size decreases, its surface-to-volume ratio increases, and the melting temperature decreases as a result of the improved free energy at the particle surface [73]. For instance, the melting temperature of 3 nm Au NPs is 300 degrees lower than the melting temperature of bulk gold [14]. In addition, NP composition plays an important role in thermal stability. For example, the thermal stability of Au in $\mathrm { A u } _ { 0 . 8 } \mathrm { F e } _ { 0 . 2 }$ is signifcantly higher than of pure Au or $\mathrm { A u } _ { 0 . 2 } \mathrm { F e } _ { 0 . 8 }$ [74]. Generally, bimetallic alloy NPs show higher thermal stabilities and melting temperatures than monometallic NPs due to the alloying efect [75, 76].

# Magnetic properties

All magnetic compounds include a ‘magnetic element’ in their formula, i.e., Fe, Co, or Ni (at ambient temperatures). Tere are only three known exceptions that are made from mixed diamagnetic elements, $\mathrm { S c _ { 3 } I n } _ { \mathrm { i } }$ , $\mathrm { Z r Z n } _ { 2 } ,$ and $\mathrm { T i B e } _ { 2 \mathrm { - } \mathrm { x } } \mathrm { C u } _ { \mathrm { x } }$ [77–80]. Otherwise, elements such as Pd, Au, or $\mathrm { A g }$ are diamagnetic. Tis all changes in the nanoscale. Several materials become magnetic in the form of NPs as a result of uneven electronic distribution [25]. For instance, FeAl is not magnetic in bulk but in the form of NPs, it is becomes magnetic [50], other examples include Pd and Au [81]. In bulk materials, the key parameters for determining magnetic properties are composition, crystallographic structure, magnetic anisotropy, and vacancy defects [82, 83]. However, on the nanoscale, two more important parameters are strongly involved, i.e., size and shape [84].

One of the interesting size-dependent phenomena of NPs is superparamagnetism [84]. As the size of the NPs decreases, the magnetic anisotropy energy per NP decreases. Te magnetic anisotropy energy is the energy keeping the magnetic moment in a particular orientation. At a characteristic size for each type of NPs, the anisotropy energy becomes equal to the thermal energy, which allows the random fipping of the magnetic moment [85], in this case, the NP is defned as being superparamagnetic [86]. Superparamagnetic NPs display high magnetization only in the presence of a magnetic feld, and once it is removed they do not retain any magnetization [87]. Superparamagnetism was long believed to form only in small ferromagnetic or ferrimagnetic NPs [88], but interestingly, other paramagnetic materials show magnetism in the nanoscale too [81].

![](images/ad155673649990adbb6ff4453f030141686dff28d3bbdf2c66d8e20f23809205.jpg)  
Fig. 4 The change in magnetic coercivity of NPs as a function of particle radius. Figure adapted from Kalubowilage et al., 2019 [89]. $r c$ critical radius, $r s p$ threshold radius for superparamagnetism

NP size efects can also be observed in changes in magnetic coercivity, i.e., the resistance of a magnetic material to changes in magnetization (Fig.  4). In contrast to large particles or bulk materials, which possess multiple magnetic domain structures, small NPs possess single magnetic domain structures below a certain critical radius $( \mathbf { r } _ { \mathrm { c } } )$ , where all magnetic spins in the NP align unidirectionally (blue arrows in Fig.  4). However, the NP radius has to be lower than the threshold radius for superparamagnetism $( { \bf r } _ { \mathrm { s p } } )$ in order to be superparamagnetic [89]. In the single-domain regime, between $\mathbf { r } _ { \mathrm { s p } }$ and $\mathbf { r } _ { \mathrm { c } } ,$ the magnetic coercivity increases as the size of the NP increases until it reaches the maximum at $\mathbf { r } _ { \mathrm { c } }$ [84]. In this size regime, due to the high magnetic coercivity, the NPs behave similarly as their larger dimension counterparts despite having a single domain structure, i.e., they become ferromagnetic for ferromagnetic materials or paramagnetic for paramagnetic materials etc. Above $\mathbf { r } _ { \mathrm { c } } ,$ the magnetic coercivity starts to decrease when multiple magnetic domains are formed in a single NP. Te critical radius represents the size where it is energetically favored for the NP to exist without a domain wall [86]. Te calculated critical radii for some common magnetic materials are $3 5 \mathrm { n m }$ of Ni, ${ 8 \mathrm { n m } }$ for Co, and $1 \mathrm { n m }$ for Fe [90]. Above that point, multi-domain magnetism begins in which a smaller reversal magnetic feld is required to make the net magnetization zero [84].

Te second key parameter for determining the magnetic properties of NPs is the shape of NPs. In comparison to the size parameter, there is signifcant less research on the efect of shape on the magnetic properties of NPs having the same volume [86]. However, large diferences in coercivity were found between a set of cubic and spherical $\mathrm { C o F e _ { 2 } O _ { 4 } \ N P s }$ [91]. Unlike the curved topography in spherical ${ \mathrm { C o F e } } _ { 2 } { \mathrm { O } } _ { 4 }$ NPs, cubic ${ \mathrm { C o F e } } _ { 2 } { \mathrm { O } } _ { 4 }$ NPs have fewer missing oxygen atoms, and it was hypothesized that this led to less surface pinning and to lower coercivity for the cubic structures [86]. Other studies also found diferences in magnetism between spherical and cubic $\mathrm { F e _ { 3 } O _ { 4 } N P s }$ [92, 93].

Similar to bulk materials, the composition also afects the magnetism of NPs. Te magnetocrystalline phase of the NP is signifcant in determining its magnetic coercivity [94]. Tis efect can be observed in magnetic bimetallic core–shell or alloy NPs with anisotropic crystalline structures. For example, Co@Pt core–shell NPs composed of an isotropically structured face-centered cubic Co core and a non-magnetic Pt shell exhibit superparamagnetic behavior with zero coercivity at room temperature [95]. In general, the compositional modifcation of NPs by the adoption of magnetic dopants is known to signifcantly change the magnetism of NPs [96].

![](images/be3635cc279e96b1b730da3ccf27901e88fd801a83410a388d23355022303d29.jpg)  
Fig. 5 Graphical illustration of the types of plasmons. A bulk; B surface propagating; and C surface localized plasmons (adapted from Khlebtsov et al., 2010 [98]). D graphical illustration of the localized surface plasmon resonance (LSPR) in NPs (adapted from Kelly et al., 2003 [99])

# Electronic and optical properties

Metallic and semiconductor NPs possess interesting linear absorption, photoluminescence emission, and nonlinear optical properties due to the quantum confnement and localized surface plasmon resonance (LSPR) efect [97, 98]. LSPR phenomena arise when the incident photon frequency is constant with the collective excitation of the conductive electrons [25].Due to this phenomenon, noble metal NPs exhibit a strong size-dependent UV– visible extinction band that is not present in the spectra of bulk metals. Generally, the optical properties of NPs depend on the size, shape, and the dielectric environment of the NPs [99].

Te collective excitations of conductive electrons in metals are called plasmons [100]. Depending on the boundary conditions, bulk plasmons, surface-propagating plasmons, and surface-localized plasmons are distinguished (Fig. 5A–C). Because of their longitudinal nature, the bulk plasmons cannot be excited by visible light. Te surface-propagating plasmons propagate along metal surfaces in a waveguide-like fashion [98]. In the case of NPs, when they are irradiated by visible light, the oscillating electric feld causes the conductive electrons to oscillate coherently. When the electron cloud is displaced relative to the nuclei, a restoring force rises from Coulomb attraction between electrons and nuclei that results in oscillation of the electron cloud relative to the nuclear framework [99]. Tis creates uncompensated charges at the NP surface (Fig.  5D). As the main efect producing the restoring force is the polarization of the NP surface, these oscillations are called surface plasmons and have a well-defned resonance frequency [98].

Experimental studies on $\mathsf { A g N P s }$ showed signifcant differences in their optical properties based on the size of NPs. For $\mathsf { A g N P s }$ with $3 0 ~ \mathrm { { n m } }$ radius, the main extinction peak was at $3 6 9 ~ \mathrm { n m }$ wavelength, while for Ag NPs with $6 0 ~ \mathrm { { n m } }$ radius, a totally diferent behavior was observed [99]. Te same researchers found that the shape of the

NPs also is critical for the optical properties, the plasmon resonance wavelength shifts to the red as the NPs become more oblate [99], demonstrating that plasmon resonance strongly depend on NPs shape. With respect to the dielectric environment of the NPs, both the surrounding solvent and the support (substrate) were found to be critical for the optical properties. For Ag NPs, both experimental and theorical studies on the efect of surrounding solvent show that plasmon wavelength linearly depends on the refractive index of the solvent [99, 101]. At the same time, $1 0 \mathrm { n m } \mathrm { A g } \mathrm { N P s }$ supported on mica substrates displayed LSPR wavelength shifts to the red compared to unsupported NPs [102]. Te biogenic synthesis of NPs can also improve the optical properties. Biologically produced $\mathrm { C e O } _ { 2 }$ NPs using Simarouba glauca leave extract were found to have diferent absorption bands and higher band gap energies compared to chemically produced $\mathrm { C e O } _ { 2 }$ NPs. Tese superior optical properties were attributed to the better crystallinity and small size of biogenic NPs compared to chemical NPs [103]. Biogenic NPs can also ofer higher photocatalytic activities, e.g., ZnO NPs produced by Plectranthus amboinicus leaf extract had higher photocatalytic activity in the photodegradation of methyl red under UV illumination compared to chemical produced ZnO NPs [104].

# Catalytic properties

Nano-catalysis, i.e., the use of NPs as catalysts, is a quickly evolving feld within chemical catalysis. Signifcantly enhanced or novel catalytic properties such as reactivity and selectivity have been reported for NP catalysts compared to their bulk analogues. Te catalytic properties of NPs depend on the size, shape, composition, interparticle spacing, the oxidation state, and the support of the NPs [76].

Te dependency of catalytic activity on the size of NPs is well studied. Te relation is an inverse one, i.e., the smaller the NPs the more catalytically active they are.

Tis relationship was found e.g., in the electro-catalysis oxidation of CO by size-selected Au NPs (1.5, 4, and $6 ~ \mathrm { n m }$ ) deposited on indium tin oxide. Te researchers observed that the smallest NPs provided the highest normalized current densities [105]. Te same relationship was also found in several other studies [106–110]. Goodman et  al., 1998 [111] speculated originally that this behavior could be attributed to quantum-size efects generated by the confnement of electrons within a small volume. Later, size-dependent changes in the electronic structure of the clusters [112] and the resulting larger number of low-coordinated atoms available for interaction by the larger surface-to-volume ratios with smaller NPs were discussed [76].

Te shape is also known to afect the reactivity and selectivity of the NPs. For the oxidation of CO by Au NPs, hemispherical NPs were found to be more active than spherical ones [113]. For the oxidation of styrene by Ag NPs, nanocubes were found to be fourteen times more efcient than nanoplates and four times more efcient than nanospheres [114]. Te reason for these dramatical changes are attributed to the increase/decrease in the relative area of the catalytically active surface facets [76] or to the diferences in stability for diferent NP shapes [115].

As for composition, several studies have shown that the use of alloys in NPs can enhance the catalytic activity as a result of the alloying efect causing changes in the electronic properties of the catalyst, decreasing poisoning efects, and providing distinct selectivities [76]. For example, the alloying of Pt with other metals such as Ru, Ni, and Co, was reported to enhance the hydrogenation and oxygen reduction activity of the NP catalyst material, as well as enhancing the resistance against CO poisoning [116–118]. However, the alloying of Pt with Fe, Ru, and Pd, resulted in reduced reactivity for methanol decomposition [119]. Tis reduction in reactivity was explained by the possible occupation of the surface with the addition metal atoms, since pure Fe, Ru, and Pd clusters are less reactive for methanol decomposition than similarly-sized pure Pt clusters. In general, the change in the composition of NPs changes the electronic structure of metal surfaces by the formation of bimetallic bonds as well as the modifcation of metal–metal bond lengths [76]. In addition, the charge-transfer phenomenon between diferent metals may favorably change the binding energy of adsorbents, lower the barriers for specifc chemical reactions, and enhance resistance against poisoning [120–122].

Te catalytic activity and stability of $2 \mathrm { n m } \mathrm { A u } \mathrm { N P s }$ dispersed on polycrystalline TiC flms displayed a strong dependence on interparticle spacing. In this study, Au NPs having two diferent interparticle spacing (30 and $8 0 \ \mathrm { \ n m }$ ) were analyzed by Termal Desorption

Spectroscopy. It was found that the sample with smaller interparticle spacing was poisoned and subsequently deactivated while the sample with longer interparticle spacing showed longer lifetime [123]. At the same time, the oxidation state of NPs was shown to afect the catalytic activities. Ru NPs under rich $\mathrm { O } _ { 2 }$ conditions and moderate temperatures oxidize and form $\mathrm { R u O } _ { 2 }$ , the reaction of CO oxidation was found to occur on the metal oxide surface not the metal surface [124]. A similar efect on CO oxidation was also observed with Pt NPs in which the reactivity of $\mathrm { P t O } _ { 2 }$ was found to be higher than Pt [125]. Te reaction of CO oxidation was compared for several metal NPs (Ru, Pd, Ir, Os, and $\mathrm { P t }$ ) and their corresponding oxides, and the oxides were indeed more reactive than the metals [126, 127]. Te superior catalytic performance of $\mathrm { R u O } _ { 2 }$ over their metallic counterparts is generally agreed on, nevertheless, the same cannot be said for other catalytically active metals such as Pt [76]. In general, these diferences in catalytic performance are attributed to the electron transfer processes at the metal/metal oxide interfaces. Consequently, the view that NP oxidation is an undesirable process that leads to the reduction of catalytic performance needs to be reconsidered [128].

An example for the efect of the support material is the role of the MgO support for Au NPs, where $\mathrm { M g O }$ was found to be important for CO oxidation and particularly, for controlling the rate of CO oxidation through oxygen vacancies [129]. Later, the process of electron charge transfer from oxygen vacancies at the metalsubstrate interface of supported Au NPs was suggested to be an ideal environment for $\mathrm { O } _ { 2 }$ activation and oxidation reactions [130]. A similar behavior was also found in the decomposition of $\mathrm { S O } _ { 2 }$ and dissociation of water by Au NPs supported on ${ \mathrm { C e O } } _ { 2 } ,$ in which $\mathrm { C e O } _ { 2 }$ supports played a critical role [131]. Te experiments showed that not only the chemical composition of the support afects the reactivity of the catalyst, but the crystal structure of the support, too [132]. Enhanced catalytic performance for CO oxidation and $\mathrm { S O } _ { 2 }$ dissociation have also been reported for Au NPs supported on metal carbides such as TiC [108, 133]. In addition to enhanced catalytic reactivities, the support also plays an important role in NP stabilization [106], i.e., the stabilization of NPs against coarsening, the stabilization of metal oxides at the NP surface, and the stabilization of intermediate reactions species [76].

# Characterization of NPs

Te properties of NPs determine their potential applications. Hence, diferent methods and techniques are used for the analysis and characterization of the various physicochemical properties of NPs. Table 1 summarizes all characterization techniques mentioned in this review and shows what properties and features can be resolved by each technique.

<html><body><table><tr><td>orphological</td><td>TEM</td><td>√</td><td>√</td><td>√</td><td>√</td><td>√</td><td></td><td></td><td></td><td></td><td>[137,309]</td></tr><tr><td>nd topo- raphical</td><td>SEM</td><td>√</td><td>√</td><td>√</td><td></td><td>√</td><td></td><td></td><td></td><td></td><td>[138,310]</td></tr><tr><td></td><td>STM</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td>[139,311]</td></tr><tr><td></td><td>DLS NTA</td><td>√ √</td><td></td><td>√</td><td></td><td></td><td></td><td></td><td></td><td></td><td>[142-144] [147,148]</td></tr><tr><td></td><td>BET</td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td><td>√</td><td></td><td>[150-153]</td></tr><tr><td>BJH</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>√</td><td>[150-153]</td></tr><tr><td></td><td>Technique</td><td>Composition Phase</td><td></td><td>Crystallinity</td><td>Functionalization Oxidation</td><td></td><td>Surface charge</td><td>Polarity</td><td>Bonding</td><td>Electrochemical Literature</td><td></td></tr><tr><td>ructural andXRD nemical</td><td></td><td></td><td>√</td><td>√</td><td></td><td></td><td></td><td></td><td></td><td></td><td>[142,153]</td></tr><tr><td></td><td>EDX</td><td>√</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>[161-164]</td></tr><tr><td></td><td>HAADF</td><td>√</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>[167-169]</td></tr><tr><td></td><td>XPS</td><td>√</td><td></td><td></td><td></td><td>√</td><td></td><td></td><td>√</td><td>√</td><td>[172-175]</td></tr><tr><td></td><td>FTIR</td><td>√</td><td></td><td></td><td>√</td><td>√</td><td></td><td>√</td><td>√</td><td></td><td>[179,180]</td></tr><tr><td></td><td>Zeta potential</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td>[182-186]</td></tr><tr><td></td><td>CV Raman spec-</td><td></td><td></td><td>√</td><td></td><td>√</td><td></td><td></td><td>√</td><td>√</td><td>[190,191] [195,196]</td></tr><tr><td></td><td>troscopy Technique</td><td>Toughness</td><td>Tensile</td><td>Compressive</td><td>Elasticity</td><td></td><td>Viscoelasticity Hardness</td><td>Stiffness</td><td></td><td></td><td></td></tr><tr><td>echanical</td><td></td><td></td><td>strength</td><td>strength</td><td></td><td></td><td></td><td></td><td></td><td></td><td>Literature</td></tr><tr><td></td><td>UTM Nano-inden-</td><td>√</td><td>√</td><td>√ √</td><td>√ √</td><td></td><td>√</td><td></td><td></td><td></td><td>[255,256] [258,259]</td></tr><tr><td></td><td>tation DMA</td><td></td><td></td><td></td><td></td><td>√</td><td></td><td>√</td><td></td><td></td><td></td></tr><tr><td></td><td>Technique</td><td>Absorption</td><td></td><td>Reflectance Fluorescence</td><td>Luminescence Bandgap</td><td></td><td>Electronic</td><td>Photoactivity</td><td>Electrical</td><td></td><td>[261,262] Literature</td></tr><tr><td>ptical, ectronic,and</td><td>Raman spec-</td><td></td><td></td><td></td><td></td><td></td><td>state √</td><td></td><td> conductance</td><td></td><td>[195,196]</td></tr><tr><td>ectrical</td><td>troscopy</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>SERS</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td>[197]</td></tr><tr><td></td><td>UV-vis</td><td>√</td><td>√</td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td><td>[200-204]</td></tr><tr><td></td><td>PL</td><td></td><td></td><td>√</td><td>√</td><td></td><td></td><td></td><td>√</td><td></td><td>[200-204]</td></tr><tr><td></td><td>DRS</td><td></td><td></td><td></td><td></td><td>√</td><td>√</td><td>√</td><td></td><td></td><td>[206-208]</td></tr></table></body></html>

<html><body><table><tr><td></td><td>Technique</td><td>Absorption</td><td>Reflectance Fluorescence</td><td></td><td>Luminescence Bandgap</td><td>Electronic state</td><td></td><td>PhotoactivityElectrical conductance</td><td></td><td>Literature</td></tr><tr><td></td><td>Elipsometry</td><td>√ √</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td>[211,212]</td></tr><tr><td></td><td>Technique</td><td>Saturation magnetization</td><td>Remnant magnetization</td><td>Coercivity</td><td>g-factor</td><td>intensity</td><td>Magnetic field Magnetic force</td><td>Magnetic susceptibility</td><td></td><td>Literature</td></tr><tr><td rowspan="4">Magnetic</td><td>MFM</td><td></td><td></td><td></td><td>√</td><td>√</td><td>√</td><td></td><td></td><td>[216-218]</td></tr><tr><td>VSM SQUID</td><td>√ √</td><td>√ √</td><td>√ √</td><td></td><td></td><td></td><td></td><td>√</td><td>[221,222] [226,227]</td></tr><tr><td>ESR</td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td><td>[231,232]</td></tr><tr><td>Technique</td><td>Melting point</td><td>Crystallization point</td><td>Structural- phase transition</td><td>Heat capacity</td><td></td><td>Thermal conductivity</td><td>Thermal Stability</td><td>Oxidative stability</td><td>Literature</td></tr><tr><td>Thermal</td><td>DSC</td><td>√</td><td>√</td><td>√</td><td>√</td><td></td><td></td><td></td><td>√</td><td>[238,239]</td></tr><tr><td rowspan="3"></td><td>DTA</td><td>√</td><td>√</td><td>√</td><td></td><td></td><td></td><td></td><td>√</td><td>[249,250]</td></tr><tr><td>TGA</td><td>√</td><td></td><td>√</td><td></td><td></td><td></td><td>√</td><td></td><td>[249,250]</td></tr><tr><td>THW</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td>√</td><td></td><td>[252, 253]</td></tr></table></body></html>

# Morphological and topographical characterization

Te morphological and topographical features of NPs are of great interest since they infuence most of the properties of NPs as described above. Tese features include the size, shape, dispersity, localization, agglomeration/aggregation, surface morphology, surface area, and porosity of the NPs. Te following techniques are regularly used for the characterization of morphological and topographical features of NPs.

Electron microscopy (EM) Scanning electron microscopy (SEM), scanning tunneling microscopy (STM), and transmission electron microscopy (TEM) are frequently employed for the analysis of NP size, shape, and surface. In SEM, an electron gun is used to produce a beam of electrons that is controlled by a set of lenses to follows a vertical path through the microscope until it hits the samples. Once the sample is hit by the beam, electrons and X-rays are ejected from the sample. Detectors are then used to collect the X-rays and scattered electrons in order to create a 3D image of the sample. SEM provides diferent information about the NPs such as size, shape, aggregation, and dispersion [134]. Similarly, TEM provides information about the size, shape, localization, dispersity, and aggregation of NPs in two-dimensional images [25]. TEM employs an electromagnetic lens that focuses a very fne beam of electrons into an ultrathin section of the sample. Tis beam passes through the specimen where the electrons either scatter or penetrate the sample and hit a fuorescent screen at the bottom of the microscope. Te diference in electron densities is used for the contrast to create an image of the specimen. TEM can be also used for the characterization of NP crystal structure through the use of selected area electron diffraction (SAED), where the electron beam is focused on a selected area in the sample and the scattered electrons are used to obtain a difraction pattern. STM is based on the phenomenon of quantum tunneling, where a metallic tip is brough very close to the sample surface and used to apply voltage. When voltage is applied, electrons from the sample surface are extracted creating an electrical current that is used to reconstruct an image of the surface with atomic resolution [135]. STM is mainly used to characterize the topography of NPs. For inorganic NPs, these techniques ofer excellent approaches for the determination of morphological features of NPs. For organic NPs (or NPs coated with biological materials), these techniques require sophisticated sample preparations which constitute major restrictions to their use [136]. Te sample preparation for these techniques might cause sample dehydration, which might lead e.g. to sample shrinking and aggregation [136].

Examples: TEM was used for the characterization of Ag NPs produced by Arbutus unedo leaf extract. In this example, the NPs have a spherical morphology with a uniform size of $3 0 ~ \mathrm { { n m } }$ . Te NPs were found to agglomerate into small aggregates, each including $5 { \mathrm { - } } 6 \mathrm { N P s }$ . At the same time, the SAED approach was used to determine the crystal structure of the NPs. Te majority of the NPs were found to be single crystalline cubic materials predominately oriented along their (111) direction [137]. For the characterization of Ag NPs produced by Diospyros kaki leaf extract, SEM helped to show that the NPs were also spherical and the size was $3 2 ~ \mathrm { { n m } }$ with some deviations [138]. STM is less frequently used for the characterization of biogenic NPs. Te features of $\mathrm { A g N P s }$ produced by lime, sweet-lime, and orange juices were compared using STM technique [139].

Dynamic light scattering (DLS) Tis technique is a common approach for the analysis of NP size and size distribution. Tis approach involves the measurement of light interference based on the Brownian motion of NPs in suspension, and on the correlation of NP velocity (difusion coefcient) with their size using Strokes-Einstein equation [140]. Te size distribution range of NPs is shown as the polydispersity index, which is the output of an autocorrelation function [136]. Te polydispersity index values lie between 0 and 1, where 0 represents a completely homogenous population and 1 represents a highly heterogeneous population. Tis technique also allows the analysis of non-spherical NPs through the use of multistage DLS [136]. Tis technique is also referred to as photon correlation spectroscopy (PCS) [141].

Examples: DLS was used to measure the size and the size distribution profle of a wide range of biogenic NPs. Te average size of Ag NPs produced by Trichoderma koningii fungi was found to be around $2 5 \mathrm { n m }$ and the size distribution profle was between 14 and $3 4 \mathrm { n m }$ . Te polydispersity index for those NPs was 0.681, which indicates that they are polydispersed [142]. While the average size of $\mathsf { A g N P s }$ produced by potato (Solanum tuberosum) was found to be around $1 0 { - } 1 2 ~ \mathrm { n m }$ with a wider distribution profle between $3 { - } 6 5 \ \mathrm { n m }$ [143]. In a diferent application, DLS was employed to study the size increase of biogenic $\mathrm { { M n O } _ { 2 } }$ NPs overtime, demonstrating that their size is $7 . 5 ~ \mathrm { n m }$ after $3 \ \mathrm { m i n }$ of the initiation of the reaction, then their size grows overtime until it become $5 4 ~ \mathrm { n m }$ after 31 min [144].

Nanoparticle tracking analysis (NTA) Tis method is used for the analysis of NP size in suspensions based on their Brownian motion. Like in DLS, the rate of NP movement is correlated with their size using Strokes-Einstein equation, allowing the measurement of size distribution profles for NPs with $1 0 { - } 1 0 0 0 \ \mathrm { n m }$ diameter. Its advantage over DLS is that NP motion is analyzed by video. Individual positional changes of NPs are tracked in two dimensions, which are used to determine NP difusion rates, and by knowing the difusion coefcient, the hydrodynamic diameter of the particles can be calculated. In DLS, individual NPs are not visualized, but instead, the time-dependent intensity fuctuations caused by Brownian motion are used to calculate the polydispersity index [145]. NTA was found to be more precise for sizing monodisperse as well as polydisperse organic NPs compared to DLS [146].

![](images/4837ad27afe5d8bf953c0ad0eb84995448ae01a20d0457f9b6925b05f97ee7d3.jpg)  
Fig. 6 Principles of the BET and BJH methods. The BET method (steps 1–3) is based on the adsorption of nitrogen on the NP surface. After the formation of a monolayer, nitrogen is desorbed, and the surface area is calculated. The BJH method (steps 1, 2, 4, and 5) is based on the complete flling of NP pores with liquid nitrogen. When saturation is reached, nitrogen is desorbed, and pore size is calculated

Examples: NTA was used to measure the size and dispersity of $\mathsf { A g N P s }$ produced by Camellia sinensis (green tea) powder, the NPs were found to be well dispersed in an aqueous medium with an average size of $4 5 \pm 1 2 ~ \mathrm { n m }$ [147]. For Se NPs produced by lactic acid bacteria, NTA was employed to measure the size and the concentration of NPs. Te average size was found to be $1 8 7 \pm 5 6 \ \mathrm { n m }$ with a concentration of $( 4 . 6 7 \pm 0 . 3 0 ) \times 1 0 ^ { 9 }$ Se NPs per ml [148].

Brunauer–Emmett–Teller (BET) method Tis method is based on the adsorption and desorption principle developed by Stephen Brunauer, Paul Emmett, and Edward Teller, and it is considered one of the best methods for the analysis of NP surface area [25]. In BET analysis, a partial vacuum is created to produce adsorption between the sample and liquid $\Nu _ { 2 }$ (because the interaction between solid and gaseous phases is weak, the surface is cooled with liquid $\Nu _ { 2 }$ to obtain detectable amounts of adsorption). After the formation of adsorption monolayers, the sample is removed from the $\Nu _ { 2 }$ atmosphere and heated to cause the adsorbed $\Nu _ { 2 }$ to be released from the material (desorption) and quantifed. Te data collected is displayed in the form of isotherms (graphs representing the amount of $\Nu _ { 2 }$ adsorbed as a function of relative pressure at a constant temperature). Te data is displayed in fve isotherms where the information is used to determine the surface area of the sample [25, 149]. Figure 6 graphically illustrates the principle of this method.

Examples: Te BET method was employed to measure the surface area of $\mathrm { C e O _ { 2 } }$ NPs produced by Eucalyp‑ tus globulus leaf extract. Te surface area was found to be $4 0 . 9 6 ~ \mathrm { m } ^ { 2 } / \mathrm { g }$ of biogenic $\mathrm { C e O } _ { 2 }$ NPs, much higher than the commercial $\mathrm { C e O } _ { 2 }$ NPs $( 8 . 5 \ \mathrm { m } ^ { 2 } / \mathrm { g } )$ [150]. BET was also used to measure the surface area of $\mathrm { S i O } _ { 2 }$ NPs produced by rice husk, CuO NPs produced by Leucaena leucocephala leaf extract, and $\mathrm { A g N P s }$ produced by Acan‑ thospermum hispidum leaf extract. In these examples, the surface area was $7 . 1 5 ~ \mathrm { m } ^ { 2 } / \mathrm { g }$ , $4 7 . 5 4 \ \mathrm { m } ^ { 2 } / \mathrm { g } ,$ , and 9.91 $\mathrm { m } ^ { 2 } / \mathrm { g } ,$ respectively [151–153].

Barrett–Joyner–Halenda (BJH) method Tis method is based on the Barrett–Joyner–Halenda principle and is used for the determination of porosity (or pore size)

of NPs. Similar to the BET method, this method also involves the use of $\Nu _ { 2 }$ gas to adsorb to the sample. In the BJH method, the process is extended so the gas condensates in the sample pores as pressure increases. Te pressure is increased until a saturation point is achieved, at which all the pores of the sample are flled with liquid. Afterwards, the condensated gas is allowed to evaporate where the desorption data is calculated and correlated to the pore size using a modifed Kelvin equation (Kelvin model of pore flling) [154, 155]. Figure 6 graphically illustrates this method.

Examples: Te BJH method was employed to study the pore size of a wide range of biogenic NPs, for instance, the pore size of $\mathrm { C e O } _ { 2 }$ NPs produced by Eucalyptus glob‑ ulus leaf extract was found to be $7 . 8 ~ \mathrm { n m }$ [150], the pore size of CuO NPs produced by Leucaena leucocephala leaf extract was $2 . 1 3 ~ \mathrm { n m }$ [152], the pore size of $\mathrm { S i O } _ { 2 }$ NPs produced by rice husk and Ag NPs produced by Acan‑ thospermum hispidum leaf extract were much larger, being $2 9 . 6 3 \mathrm { n m }$ and $3 6 . 3 4 \mathrm { n m }$ , respectively [151, 153].

# Structural and chemical characterization

Te structural characterization of NPs and the study of their composition is of high interest due to the strong infuence of these parameters on the physicochemical properties. Te following techniques are commonly used for the analysis of NP composition, phase, crystallinity, functionalization, chemical state (oxidation), surface charge, polarity, bonding, and electrochemical properties.

X‑ray difraction analysis (XRD) Tis technique is based on irradiating a material with incident X-rays and then measuring the intensities and scattering angles of the X-rays that leave the material [156]. Tis technique is widely used for the analysis of NP phase and crystallinity. However, the resolution and accuracy of XRD can be afected in cases where the samples have highly amorphous characteristics with varied interatomic distances or when the NPs are smaller than several hundreds of atoms [25].

Examples: For the characterization of biogenic Ag NPs, the XRD results of $\mathrm { A g \ N P s }$ produced by Tricho‑ derma koningii [142], Solanum tuberosum [143], and Acanthospermum hispidum leaf extract [153] displayed characteristic peaks occurring at roughly $2 \Theta = 3 8 { \mathrm { ~ } } ^ { \mathrm { ~ o ~ } }$ , $4 4 ^ { \circ }$ and $6 4 ^ { \mathrm { o } }$ corresponding to (111), (200), and (220) planes, respectively. Tese results are in good agreement with the reference to the face-centered cubic structure of crystalline silver. However, the XRD results of Ag NPs produced by Solanum tuberosum were not as clear as the other biogenic Ag NPs and had several impurities. Te structural characterization of Pd NPs produced by

Garcinia pedunculata Roxb leaf extract by XRD showed the distinct peaks of Pd, however, three other peaks were also observed at 2θ of $3 4 . 2 2 ^ { \circ }$ , $5 5 . 7 2 ^ { \circ }$ , and $8 6 . 3 8 ^ { \circ }$ , indicating the presence of PdO phases along with Pd NPs [157].

Energy‑dispersive $X .$ ‑ray spectroscopy (EDX) Tis technique is based on the irradiation of the sample with an electron beam. Electrons of the electron beam when incident on the sample surface eject inner shell electrons, the transition of outer shell electrons to fll up the vacancy in the inner shell produces X-rays. Each element produces a characteristic X-ray emission pattern due to its unique atomic structure, and therefore can be used to perform compositional analysis [158]. Te shortfall of EDX is that the resulting spectra give only qualitative compositional information (it shows the chemical elements present in the sample without quantifcation). However, the peak intensities to some extent give an estimate of the relative abundance of an element in a sample [159]. Tis technique does not require sophisticated additional infrastructures, usually it is a small device that is connected to an existing SEM or TEM. Tis allows the use of SEM or TEM for the morphological characterization and EDX is used simultaneously for the analysis of chemical composition [160].

Examples: Te EDX technique is usually used for the confrmation of the presence of the element in question in biogenic NPs. For instance, EDX was used to confrm the presence of Au in Au NPs produced by Jasminum auriculatum leaf extract [161], the presence of Pd in Pd NPs produced by Pulicaria glutinosa extract [162], the presence of Te in Te NPs produced by Penicillium chry‑ sogenum PTCC 5031 [163], and the presence of Ag in Ag NPs produced by Trichoderma viride [164].

High‑angle annular dark‑feld imaging (HAADF) Tis method is used for the elemental mapping of a sample using a scanning transmission electron microscope (STEM). Te images are formed by the collection of incoherently scattering electrons with an annular dark-feld detector [165]. Tis method ofers high sensitivity to variations in the atomic number of elements of the sample, and it is used for elemental composition analysis usually when the NPs of interest consist of relatively heavy elements. Te contrast of the images is strongly correlated with atomic number and specimen thickness [166].

Examples: Te employment of HAADF-STEM in the characterization of biogenic Au–Ag–Cu alloy NPs confrmed the presence of the three elements in the same NP [167]. Similarly, this approach revealed that Ag NPs produced by Andrographis paniculata stem extract were coated with an organic polymer [168]. Te employment of this approach in the characterization of Cu NPs produced by Shewanella oneidensis revealed that Cu NPs remained stable against oxidization under anaerobic conditions, but when they were exposed to air a thin shell of $\mathrm { C u _ { 2 } O }$ develop around the NPs [169].

$X$ ‑ray photoelectron spectroscopy (XPS) Tis technique is considered the most sensitive approach for the determination of NP exact elemental ratios, chemical state, and exact bonding nature of NP materials [25]. XPS is based on the photoelectric efect that can identify the elements within a material, or covering a material, as well as their chemical state with high precision [170]. XPS can also be used to provide in-depth information on electron transfer, e.g., for Pt NPs supported on ${ \mathrm { C e O } } _ { 2 } ,$ it was found that per ten Pt atoms only one electron is transferred to the support [171].

Examples: Te XPS technique can employed for different purposes. For instance, it was used for measuring the purity of Au NPs produced by cumin seed powder [172]. XPS was used for the determination of the oxidation states of Pt NPs produced by Nigella sativa seeds and Ag NPs produced by Rosa canina. XPS results of Pt NPs showed the presence of three oxidation states for Pt (Pt (0), Pt (II), and Pt (IV)) and two oxidation states for Ag NPs (Ag (0) and Ag (I)). In both cases, the zero-oxidation state was the abundant one, the presence of a small amount of the other oxidation states suggests that some of the NPs were oxidized or had unreduced species [173, 174]. XPS was used for the determination of the exact elemental ratios and the bonding nature of $\mathrm { F e S } \mathrm { N P s }$ produced by Shewanella putrefaciens CN32. For the exact elemental ratios, the researchers compared biogenic and abiotic FeS NPs and found that biogenic FeS NPs had a 2.3:1 Fe:S ratio while the abiotic NPs had a 1.3:1 Fe:S ratio. For the bonding nature, it was determined that the surface of NPs had Fe(II)-S, Fe(III)-S, Fe(II)-O, and Fe(III)-O bonds [175].

# Fourier‑transform infrared spectroscopy (FTIR)

Tis technique is based on irradiating a material with infrared light, where the absorbed or transmitted radiation is recorded. Te resulting spectrum represents a unique fngerprint of samples, where information about the nature of the sample can be obtained such as the bonds involved, polarity, and oxidation state of the sample [176, 177]. Tis technique is mainly used for the characterization of organic materials such as the surface chemical composition or functionalization of NPs. It is also used for the identifcation of contaminants when high purity is sought [178].

Examples: For biogenic NPs, FTIR is usually used for the identifcation of probable functional groups present on the surface of NPs that are responsible for the reduction and stabilization of the NPs. For plant-mediated NP synthesis, for instance for $\mathsf { A g N P s }$ produced by Camel‑ lia sinensis, the FTIR results indicate the presence of Camellia sinensis phytocompounds, such as cafeine and catechin, on the surface of $\mathsf { A g N P s }$ that could be responsible for the reduction of $\mathrm { A g }$ or act as stabilizing agents [147]. For Ag NPs produced by Solanum tuberosum, the NPs were found to be capped by amide and amine groups [143]. For $\mathrm { C e O } _ { 2 }$ NPs produced by Eucalyptus globulus, the polyphenol groups present in Eucalyptus globulus extract were found on the surface of NPs suggesting their involvement in the reduction/stabilization process [150]. For microbe-mediated NP synthesis, FTIR results show the presence of protein residues on the surface of NPs confrming the involvement of diferent proteins in the reduction/stabilization process, such as in Ag NPs produced by Streptomyces sp. NH28 [179], in Te NPs produced by Penicillium chrysogenum PTCC 5031 [163], and in Se NPs produced by Azospirillum thiophilum [180].

Zeta potential analysis Zeta potential measurements are used for the determination of NP surface charge in colloidal solutions. Te surface charge of NPs attracts counter-ions that form a thin layer on the surface of the NPs (called Stern layer). Tis layer travels with the NPs as they difuse thought the solution. Te electric potential at the boundary of this layer is known as NP zeta potential [136]. Te instruments used to measure this potential are called zeta potential analyzers [181]. Zeta potential values are indicative for NP stability, where higher absolute value of zeta potential indicate more stable NPs [136].

Examples: Te zeta potential is a good indicator for the stability of NPs, where NPs with zeta potentials of more than $+ 3 0 \mathrm { m V }$ or less than $3 0 \mathrm { m V }$ are considered stable. Zeta potentials have been measured for a wide range of biogenic NPs. Te zeta potential for $\mathsf { A g N P s }$ produced by Ziziphus jujuba leaf extract of − $2 6 . 4 ~ \mathrm { m V }$ [182]. Ag NPs produced by other organisms have diferent zeta potential values, for example, $\mathsf { A g N P s }$ produced by Punica gra‑ natum peel extract have a zeta potential of $4 0 . 6 ~ \mathrm { m V }$ indicating their higher stability [183], while Ag NPs produced by Aspergillus tubingensis have a zeta potential $\mathrm { o f } + 8 . 4 8$ indicating their relative instability [184]. Te $\mathrm { p H }$ of the sample is another important parameter for zeta potential values, the higher pH the lower the zeta potential value [185]. Having diferent zeta potential values for the same type of NPs depending on the organism used for their synthesis is not unique to silver, Se NPs also show diferent potential values depending on the organism used for their synthesis [186].

Cyclic voltammetry (CV) CV is an electrochemical technique for measuring the current response of redox-active solutions to a linearly cycled potential sweep between two or more set values. Te CV technique involves the use of three electrodes: a working electrode, reference electrode, and counter electrode. Tese electrodes are introduced to an electrochemical cell flled with an electrolyte solution and where voltage is in excess, the potential of the working electrode is cycled and the resulting current is measured. Tis technique is used for determining information about the reduction potential of materials, the kinetics of electron transfer reactions, and the thermodynamics of redox processes [187–189].

Examples: Te CV technique can be employed for two diferent purposes in the context of biogenic NP characterization. Firstly, it can be used for measuring the stability of NPs in electrocatalysis. For this purpose, the biogenic NPs are assembled on an electrode of the electrolysis cell and are tested for their electrocatalytic behavior against a redox reaction over diferent cycles. As an example, Ag NPs produced by Citrus sinensis were found to be stable in phenolic compounds redox reactions over multiple cycles [190]. Secondly, CV can be used for monitoring the progress of reduction of metallic NPs or for the determination of the reducing agent involved in the reduction. For example, for Ag NPs produced by Indian propolis, four cyclic voltammograms were recorded, one for a water extract of Indian propolis, another for an ethanol extract of Indian propolis, and two for the constituent favonoids of Indian propolis (pinocembrin and galangin). Te four cyclic voltammograms showed similar behaviors indicating the involvement of these favonoids in the reduction of Ag and in forming Ag NPs [191].

Raman spectroscopy Tis technique is based on irradiating a sample with monochromatic light emitted by a laser, in which the interactions between the laser light and molecular vibrations (photons and phonons) are recorded. Te technique records the inelastically scattered photons, known as Raman scattering (named after the Indian physician C. V. Raman) [192]. Te output of this technique is a unique fngerprint for each sample, which is used to characterize the chemical and intramolecular bonding of the sample. It can also be used to characterize the crystallographic orientation of the sample [193]. Surface-enhanced Raman spectroscopy (SERS) enhances Raman scattering of a sample and provides a more sensitive, specifc, and selective technique for identifying molecular structures [194]. Both techniques are also used for the characterization of optical properties, where the recorded photons and phonons are used to understand the plasmonic resonance of NPs [25].

Examples: Raman spectroscopy was used to characterize $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ NPs produced by Pisum sativum peel, the researchers found that the NPs were $\mathrm { F e _ { 3 } O _ { 4 } }$ NPs with face centered cubic phase which was in agreement with their XRD measurements [195]. Other researchers used Raman spectroscopy for studying the trace deposits of carbohydrates on ferrihydrite NPs produced by Klebsiella oxytoca, the results showed that the pores of NPs had more deposits of carbohydrates that the surface of the NPs [196]. For Au NPs produced by Raphidocelis subcap‑ itata (green algae), several biomolecules were suggested for their involvement in this process. SERS technique was used to study Au NPs surface-associated biomolecules in order to narrow down the list of biomolecules involved in the bioproduction process. Te researchers found that several biomolecules such as, glutathione, $\beta$ -carotene, chlorophyll a, hydroxyquinoline, and NAD were associated with Au NPs surface, thus, ruling out other molecules such as, glutaraldehyde fxing agent, saccharides, FAD, lipids, and DNA from the list [197].

# Characterization of optical, electronic, and electrical properties

In addition to Raman spectroscopy and SERS, also other techniques can be employed to study and characterize the optical properties of NPs. Tese techniques give information about the absorption, refectance, fuorescence, luminescence, electronic state, bandgap, photoactivity, and electrical conductance properties of NPs.

Ultraviolet–visible spectroscopy (UV–vis) and  photolu‑ minescence spectroscopy (PL) In absorption spectroscopy such as UV–vis, the transition of electrons from the ground state to an excited state is measured, while in photoluminescence spectroscopy, the transition of electrons from the excited state to the ground state is measured [198]. UV–vis spectroscopy uses visible and UV light to measure the absorption or refectance of a sample. In photoluminescence spectroscopy, usually UV light is used to excite the electron and then measure the luminescence or fuorescence properties of a sample [199].

Examples: UV–vis spectroscopy is a simple and common technique that is used for the characterization of the optical properties of NPs. For instance, for the characterization of the optical properties of $\mathsf { A g N P s }$ produced by Trichoderma viride, the UV–vis spectrum showed that a Ag surface plasmon band occurs at $4 0 5 ~ \mathrm { n m }$ , which is a characteristic band for $\mathrm { A g } \mathrm { N P s }$ . Te intensity of this band over the reaction time increased as a result of increasing $\mathsf { A g } \ \mathrm { N P }$ concentration in the solution. In the same study, the photoluminescence properties of these NPs were recorded, with an emission in the range between $3 2 0 { - } 5 2 0 ~ \mathrm { n m }$ , which falls in the blue-orange region [164]. For biogenic Cu NPs, the common absorption peaks are located between $5 3 0 { - } 5 9 0 \ \mathrm { n m }$ . Te diference in NP size and the bio-active molecules used for the reduction process are believed to be the reasons behind the diferences in the absorption peaks [200]. For instance, $1 5 ~ \mathrm { n m }$ spherical $\mathrm { C u N P s }$ produced by Calotropis procera have an absorption peak at $5 7 0 ~ \mathrm { n m }$ [201], while $7 6 ~ \mathrm { n m }$ spherical Cu NPs produced by Duranta erecta have an absorption peak at $5 8 8 \ \mathrm { n m }$ [202]. Te same applies to photoluminescence efects, where $2 7 \ \mathrm { n m }$ spherical Cu NPs produced by Tilia extract emit light of $5 6 3 ~ \mathrm { n m }$ (dark brown) [203], while $1 9 \mathrm { n m }$ spherical $\mathrm { C u N P s }$ emit light of $4 3 0 \mathrm { n m }$ (green) [204].

![](images/4c7137efd0a68f92433dc1a614ecec6c6ab39ee7d069bae3749a487628a706a1.jpg)  
Fig. 7 Magnetic force microscopy lift height method. The frst scan is done very close to the surface to obtain the topography of the sample. Then, the tip is lifted and a second scan is performed following the topography outline obtained in the frst scan

UV–vis difuse refectance spectroscopy (DRS) Tis technique uses UV and visible light to measure the difuse refectance of a material (the refection of light in many angles, as opposed to specular refection). Te resulting difuse refectance spectra are used to determine the electronic state of a sample, which is then used to calculate the bandgap [25]. Bandgap determination is crucial for determining conductance and photocatalytic properties especially for semiconductor NPs [205].

Examples: Te DRS technique was used to calculate the bandgap for a wide range of biogenic NPs. For instance, $\mathrm { T i O } _ { 2 }$ NPs produced by Andrographis paniculata exhibit an optical energy bandgap of $3 . 2 7 \ \mathrm { e V }$ [206]. Interestingly, biogenic ZnO NPs produced by diferent organism show diferent bandgaps, for example, ZnO NPs produced by Pseudomonas putida have a bandgap of $4 \mathrm { e V }$ [207], while ZnO NPs produced by Calotropis procera leaf extract have a bandgap of 3.1 eV [208].

Spectroscopic ellipsometry Tis technique is based on irradiating a sample with polarized light to measures changes in polarization. It is widely used to calculate the optical constants of a material (refractive index and extinction coefcient) [209]. Tis technique is also used to characterize the electrical conductivity and dielectric properties of materials [210].

Examples: Spectroscopic ellipsometry is not a common technique for the characterization of biogenic NPs. For chemically produced NPs, the optical properties for different-sized Au NPs partially embedded in glass substrate were measured by spectroscopic ellipsometry. In this example, a clear transition from LSPR to SPR mode was found as the thickness increases. Moreover, the partiallyembedded Au NPs had much higher refractive index sensitivity compared to Au NPs fully immobilized in a glass substrate [211]. Spectroscopic ellipsometry was also used to measure the changes in the optical constants of a layer of $5 \ \mathrm { n m } \ Z \mathrm { n O }$ NPs induced by UV illumination. In this case, it was found that the UV illumination of $_ { \mathrm { Z n O } }$ NPs in inert atmospheres resulted in a clear blue shift in the absorption (Moss-Burstein shift). Te UV illumination of $_ { \mathrm { Z n O } }$ NPs results in the desorption of $\mathrm { O } _ { 2 }$ from the NPs surface leading to the population of the lowest levels in conduction band with mobile electrons. Tis phenomenon is reversible, in which the exposure to $\mathrm { O } _ { 2 }$ from air results in the scavenging of these mobile electrons [212].

# Characterization of magnetic properties

Te magnetic properties of NPs are of high importance, as they potentially give NPs great advantages in catalysis, electronics, and medical applications. Several techniques were developed for the detection and quantifcation of small magnetic moments in NPs.

Magnetic force microscopy (MFM) Tis technique is a variety of atomic force microscopy (AFM), in which a magnetic tip is used to scan the sample. Te magnetic tip is approached very close to the sample, where the magnetic interactions between the tip and the sample are recorded [213]. At closer distances to the sample $\left( 0 { - } 2 0 \ \mathrm { n m } \right)$ , other forces such as van der Waals forces also interact with the tip. Terefore, MFM measurements are often operated with two-pass scanning method (also called lift height method) [214] (Fig.  7). In this method, the tip is frstly used to measure the topography of the sample including the molecular forces as van der Waals. Afterwards, the tip is lifted and a second scan is operated following the same topography outline. In the second scan, the short-ranged van der Waals forces disappear and the long-range magnetic forces are almost exclusively recorded. In an experimental study, researchers found that $2 2 \mathrm { n m }$ was the optimal scanning height for the second scan, at which van der Waals forces are very weak while the distance is still small enough to measure the magnetic interactions for Pd-Fe bimetallic NPs [215].

Examples: MFM was heavily used for the characterization of magnetite NPs produced by magnetotactic bacteria. For instance, the size and orientation of the magnetic moment of magnetite NPs produced by Magnetospiril‑ lum gryphiswaldense strain MSR-1 were studied by MFM [216], in which the size of the magnetic moment was found to be $1 . 6 1 \times 1 0 ^ { - 1 7 } \ \mathrm { A m } ^ { 2 }$ . In a diferent study, MFM was used to characterize the magnetic properties and to estimate the size of the magnetic kernel of the magnetosomes produced by the same strain, and it was determined that the NPs behaved like single monodomain nanomagnets [217]. Te magnetic properties of NPs made from materials such as Pd that only exhibit signifcant magnetism on the nanoscale can also be studied by MFM, however, the magnetic moment of these NPs is much lower than for ferromagnetic NPs. Te magnetic decoration of Pd NP samples with $\mathrm { F e _ { 2 } O _ { 3 } }$ NPs strongly enhances the weak magnetic signal of Pd NPs up to 15 times [218]. Tis approach could make the MFM technique useful for the characterization of weak magnetic NPs.

Vibrating‑sample magnetometry (VSM) Tis technique measures the magnetic properties of materials based on Faraday’s law of induction. In VSM, the sample is placed in a constant magnetic feld in a special holder that vibrates vertically. As the holder starts vibrating, the magnetic moment of the sample creates a magnetic feld that changes as function of time. Te alternating magnetic feld created in the sample induces an electric current that is recorded and used to calculate the magnetic properties of the sample [219, 220].

Examples: For the characterization of $\mathrm { F e } _ { 2 } \mathrm { O } _ { 3 }$ NPs produced by Tridax leaf extract, VSM studies revealed that the NPs had a saturation magnetization of $7 . 7 8 \mathrm { \ e m u / g } ,$ a remnant magnetization of $0 . 0 5 4 \mathrm { \ e m u / g } ,$ and a coercivity of − $1 . 6 \ G$ [221]. In other studies, VSM was used to compare the magnetic properties of iron oxide NPs produced Moringa oleifera with the magnetic properties of the same NPs but coated with chitosan. Te researchers found that saturation magnetisation, remnant magnetization, and coercivity have lower values when the NPs are coated with chitosan [222].

Superconducting quantum interference device (SQUID) magnetometry Tis technique measures the magnetic properties of materials based on the Josephson efect. Niobium (Nb) or other metal alloys are used in the device which needs to be operated at temperatures very close to the absolute zero to main superconductivity, where liquid helium is used to maintain the cold environment [223]. However, other kinds of SQUID also exist where high-temperature superconductors are used [224]. After reaching superconducting environments, the Josephson junctions contained in the device help to create a supercurrent, which is recorded and used to calculate the magnetic properties of the sample [225].

Examples: For the characterization of iron oxide NPs produced by Cnidium monnieri seed extract, SQUID magnetometry revealed that the NPs had a saturation magnetization of $5 4 . 6 0 \mathrm { \ e m u / g } ,$ a remnant magnetization of $1 . 1 5 \mathrm { \ e m u / g }$ , a coercivity of 11 Oe, and a magnetic susceptibility $\mathrm { { o f + 1 . 6 9 \times 1 0 ^ { - 3 } \ e m u / \ c m ^ { 3 } { \cdot } O e } }$ at room temperatures, indicating the superparamagnetic behaviour of these NPs [226]. SQUID magnetometry was also used for the characterization of the magnetic properties of zinc incorporated magnetite NPs produced by Geobacter sulfurreducens, showing that the loading of only $5 \%$ zinc results in the enhancement of saturation magnetization of the NPs by more than $5 0 \%$ [227].

Electron spin resonance spectroscopy (ESR) Tis technique measures the magnetic properties of materials by characterizing and quantifying the unpaired electrons in the sample. Electrons are charged particles that spin around their axis, which can align in two diferent orientations $( + \sqrt [ 1 ] { 2 } \mathrm { a n d } - \sqrt [ 1 ] { 2 } )$ when the sample is placed in strong magnetic feld. Tese two alignments have diferent energies due to the Zeeman efect. Since unpaired electrons can change their spins by absorbing or emitting photons, in ESR the sample is irradiated with microwave pulses to excite electron spins until a resonance state is reached [228]. Tis technique is also referred to as electron paramagnetic resonance spectroscopy (EPR). It can be used to measure the ferromagnetic and antiferromagnetic properties of NPs [229, 230].

Examples: ESR was used to characterize the magnetic properties of iron oxide NPs produced by Ficus carica. Te trees naturally produce iron oxide NPs as a defence mechanism when are they are subjected to stress. Te researchers found that the magnetic properties of iron oxide NPs produced by the same tree but grown in different environmental conditions have diferent magnetic properties. In addition, a magnetic anisotropy of the signal was visible as the magnetic properties of these NPs varied strongly at diferent temperatures [231]. ESR was also used to characterize the magnetic properties of Se nanomaterials produced by anaerobic granular sludge. Te ESR results revealed the presence of Fe(III) atoms incorporated in the Se nanomaterial, which enhanced their overall magnetic properties, giving it ferromagnetic behaviour [232].

# Characterization of thermal properties

Several techniques can be used for the characterization of the thermal properties of NPs, such as melting points, crystallization and structural-phase transition points, heat capacity, thermal conductivity, and thermal and oxidative stability.

Diferential scanning calorimetry (DSC) In this technique the analyte and a well-defned reference sample are put at the same temperature, then, the amount of heat required to increase the temperature of the sample and the reference in measured as a function of temperature. Tis technique is widely used to measure melting points [233], crystallization points, structural-phase transition points [234], latent heat capacity [235], heat of fusion [236], and oxidative stability [237].

Examples: For the characterization of $\mathsf { A g N P s }$ produced by Rhodomyrtus tomentosa leaf extract, DSC showed three exothermic peaks at 44, 159, 243, and an endothermic peak at $4 4 1 ^ { \circ } \mathrm { C }$ . Te frst peak (at $4 4 ^ { \circ } \mathrm { C } )$ ) indicates that at this temperature the NPs face a gradual loss of water from their surface. Te second peak (at $1 5 9 ~ ^ { \circ } \mathrm { C } )$ shows that the thermal decomposition of the sample happens at this temperature. Te last temperature $( 4 4 1 ^ { \circ } \mathrm { C } )$ indicates the melting temperature for those NPs [238]. For $\mathsf { A g N P s }$ produced by Parthenium hysterophorus leaf extract, DSC showed that their melting temperature was at $7 5 0 ^ { \circ } \mathrm { C }$ . Te researchers also found that these NPs had completely thermally decomposed and crystallized simultaneously [239].

Diferential thermal analysis (DTA) Tis technique is based on heating or cooling a sample and an inert reference under identical conditions, where any temperature diference between the sample and the reference is recorded. Tis technique is primarily used for the study of phase diagrams and transition temperatures [240]. However, it is also used to measure the melting points, thermal, and oxidative stability [241, 242].

Termogravimetric analysis (TGA) Tis technique measures the change in the mass of a sample as a function of temperature and/or time in a controlled atmosphere [243]. Tis technique is mainly used to study the thermal stability of materials [244], in addition, it is also used to measure structural-phase transition points [245], thermal activation energies [246], and oxidative stability [247]. Te resulting thermogram is unique for each compound and therefore can also be used for the determination of material composition [248]. TGA and DTA are usually combined in the same thermal analyzing instrument, called thermogravimetry/diferential thermal analysis (TG/ DTA) [244].

Examples: TG/DTA is a common technique for the characterization of thermal properties of biogenic NPs. For instance, the thermal properties of $\mathsf { A g N P s }$ produced by Daphne mucronate leaf extract were studied in the range between $0 { - } 1 0 0 0 ^ { \circ } \mathrm { C }$ where the sample was heated at a rate of $1 0 ~ \mathrm { ^ { \circ } C / m i n }$ . Te researchers found that between $4 0 0 { - } 5 0 0 ~ ^ { \circ } \mathrm { C }$ the NPs faced a dominant weight loss, while the weight loss below $4 0 0 ~ ^ { \circ } \mathrm { C }$ and above $5 0 0 ~ ^ { \circ } \mathrm { C }$ was negligible. Te DTA curve showed an intense exothermic peak in the range between $4 0 0 { - } 5 0 0 \ { ^ { \circ } } \mathrm { C } ,$ , this indicates that the crystallization of NPs happens in this temperature interval. Some minor weight loss events were seen below $4 0 0 ~ ^ { \circ } \mathrm { C }$ , this may be caused by the evaporation of water or the degradation of the organic components [249]. In another study, the thermal properties of Ag NPs produced by two diferent plants (Stereospermum binhchau‑ ensis and Jasminum subtriplinerve) were compared. Te researchers found that the major weight loss happens between $2 2 0 { - } 4 3 0 \ ^ { \circ } \mathrm { C }$ , which is attributed to the decomposition of biomolecules from the NP surface [250]. Tis shows that $\mathsf { A g N P s }$ produced by these plants have much higher content of biomolecules on their surface than $\mathrm { A g }$ NPs produced by Daphne mucronate. TG/DTA showed that Stereospermum binhchauensis Ag NPs crystallize at $3 1 5 ~ ^ { \circ } \mathrm { C }$ and Jasminum subtriplinerve Ag NPs at $3 4 5 ~ ^ { \circ } \mathrm { C }$ around $1 0 0 ^ { \circ } \mathrm { C }$ less than Daphne mucronate Ag NPs [250].

Transient hot wire method (THW) Tis method is used for the determination of thermal conductivity based on increasing the temperature of a material by a thin hot wire as a function of time, where the heating wire is located directly in the test sample. Te advantage of this method over other thermal conductivity measurement methods is the very short measuring time, this gives high accuracy of thermal conductivity due to the negligible values of convection in such short times [251]. In this method, the NPs are added to a solution (usually water or ethylene glycol) forming a colloidal dispersion called a nanofuid. Ten, the thermal conductivity of the nanofuid is measured and compared to the thermal conductivity of the base fuid, giving a thermal conductivity ratio which is used to evaluate the thermal conductivity of diferent NPs.

Examples: Te thermal conductivity ratios of three diferent concentrations (0.12, 0.18, and $0 . 2 4 \%$ ) of biogenic $\mathrm { S n O } _ { 2 }$ NPs produced by Punica granatum seed extract were measured in ethylene glycol at $3 0 3 ~ \mathrm { K } .$ . Te researchers found a linear relationship between NPs concentration and the thermal conductivity. Te thermal conductivity enhancement of nanofuid to base fuid was between 6 and $2 4 \%$ [252]. In another study, the thermal conductivity of $\mathrm { F e _ { 2 } O _ { 3 } }$ NPs produced by Psidium guajava leaf extract was measured in water and in ethylene glycol. Te researchers found that the thermal conductivity enhancement in ethylene glycol was better than in water, the thermal conductivity enhancement for $0 . 0 2 5 \%$ $\mathrm { F e _ { 2 } O _ { 3 } }$ NPs in water was $3 0 \%$ while in ethylene glycol was $3 4 \%$ . Moreover, the linear relationship between NPs concentration and thermal conductivity ratio was found for $\mathrm { F e } _ { 2 } \mathrm { O } _ { 3 } \mathrm { N P s }$ in both water and ethylene glycol [253].

# Characterization of mechanical properties

Several methods can be used for the characterization of mechanical properties of NPs, such as tensile and compressive strengths, elasticity, viscoelasticity, hardness, and stifness.

Tensometery Te machine used for this method is called a universal testing machine (UTM) or a tensometer. It is used to measure the elasticity (elastic modulus), tensile and compressive strengths (Young’s modulus) of materials. In this machine, the sample is placed between grips and an extensometer, where changes in gauge length are recorded as a function of load [254]. However, other mechanical changes in addition to the change in gauge length are also recorded in this machine, such as the elasticity.

Examples: Te mechanical properties of diferent biogenic NP-containing composites can be measured by this machine. For example, the mechanical properties of orthodontic elastic ligatures containing Ag NPs produced by Heterotheca inuloides were studied by comparing the maximum strength, tension, and displacement of the composite with and without the biogenic NPs. Te researchers found that maximum strength, tension, and displacement have improved after the addition of Ag NPs [255]. Interestingly, the addition of biogenic $\mathrm { A g }$ NPs produced by Diospyros lotus fruit extract to starch and polyvinyl alcohol hydrogel membranes resulted in an adverse efect. Te tensile strength and modulus of the hydrogel membranes containing 50 and $1 0 0 \mathrm { p p m } \mathrm { A g } \mathrm { N P s }$ were much lower than of the neat hydrogel membrane. Te researchers attributed this adverse efect to the possibility that the addition of $\mathsf { A g N P s }$ could have resulted in blocking the crosslinking between starch and polyvinyl alcohol, or to the possibility of the formation of breakage points in the polymer matrix due to NPs agglomeration [256].

Instrumented indentation testing Tis method is used to characterize the hardness features of materials by using a well-defned hard indenter tip typically made of diamond. Te indenter tip is used to make an indentation in the sample by placing incremental loads on the tip, after which the area of indentation in the sample is measured and used to calculate the hardness features [257]. Light microscopy, SEM, or ATM technique are usually used to visualize the indentation in the sample. Te method is also called micro- or nano-indentation testing.

Examples: Tis method was used to characterize the mechanical properties of calcite NPs produced by Ophi‑ ocoma wendtii brittlestar. Te arm plates of this brittlestar are covered by hundreds of nanoscale calcite lenses that focus light onto photoreceptor nerve bundles positioned beneath the brittlestar. Te researchers used the nanoindentation method to compare Young’s modulus, hardness and fracture toughness of biogenic calcite with geocalcite. Te results showed that the biogenic calcite lenses have higher hardness and fracture toughness compared to geocalcite (more than twofold) [258]. Bamboo is well known for its high silica content in comparison to other wood species. It produces $\mathrm { S i O } _ { 2 }$ NPs and deposits it in its epidermis in the form of silica cells. Te mechanical properties of silica cells compared to other types of cells of Moso bamboo (Phyllostachys pubescens) were studied by instrumented indentation testing. Te researchers found that the cell wall of silica cells display higher hardness and elastic recovery compared to fbre and epidermal cells, which is attributed to the presence of biogenic $\mathrm { S i O } _ { 2 }$ NPs in the silica cells [259].

Dynamic mechanical analysis (DMA) Tis method is used to study the mechanical properties of materials by measuring the strain of a material after applying a stress. Tis method helps to obtain three diferent values: storage modulus, loss modulus, and loss tangent. Tese values are important to give an overview about the stifness and viscoelasticity behavior of materials [260].

Examples: Te DMA method was used to characterize the mechanical properties of polymethyl methacrylate denture base polymer flled with Ag NPs produced by Boesenbergia rotunda. In this study frequency sweep test was used to determine the viscoelastic behavior of this nanocomposite where the temperature was constant at $3 7 ~ ^ { \circ } \mathrm { C }$ and the frequency was increasing from 0.5 to $1 0 0 ~ \mathrm { H z }$ in tension mode. Te researchers found a frequency dependence for storage modulus, loss modulus, and loss tangent for the nanocomposite with various $\mathrm { A g }$ NPs loading concentrations. Te frequency dependence of storage modulus, loss modulus, and loss tangent indicates the viscoelastic response of this polymer. However, the results showed that the storage modulus for the nanocomposite is much higher than the loss modulus over the range of frequencies, indicating the elastic dominance of the nanocomposite. Moreover, the researchers found that storage and loss moduli increase with increasing $\mathsf { A g N P s }$ loading concentrations, which is due to the interaction between polymethyl methacrylate and $\mathsf { A g N P s }$ [261].

In a diferent study, DMA was used to determine the thermomechanical properties of pol(S-co-BuA) polymer flled with cellulose nanocrystals produced by Posidonia oceanica. In this case, the behaviour of storge modulus and loss tangent were studied as a function of temperature for diferent cellulose nanocrystals loading concentrations. Te results showed that the unloaded polymer behaves like an amorphous polymer, the storage modulus remains constant until the temperature reaches $2 5 ~ ^ { \circ } \mathrm { C }$ then it starts to sharply decrease due to glass–rubber transition. A relaxation process was also evident for the unloader polymer, where the loss tangent reaches its maximum at $3 5 ~ ^ { \circ } \mathrm { C }$ then it starts to fall. Te addition of cellulose nanocrystals to the polymer positively enhanced both efects. Te dramatic drop of storage modulus at $2 5 ~ ^ { \circ } \mathrm { C }$ was less for the nanocomposite, where the drop for the polymer loaded with $1 5 \%$ cellulose nanocrystals was almost cancelled. Similar positive enhancement was found for loss tangent. Tese enhancements could be attributed to the mechanical coupling efect, in which the NPs connect and form a stif continuous network linked through hydrogen bonding [262].

# Applications of NPs

NPs, due to their above-mentioned unique or enhanced physicochemical properties, are used in a wide range of applications in diferent felds. In addition, several potential applications are in research and development. Here we present some examples of these applications.

# Applications in medicine and pharma

Metallic and semiconductor NPs have huge potential for cancer diagnosis and therapy based on their enhanced light scattering and absorption properties due to LSPR efect. For instance, Au NPs efciently absorb light and convert it into localized heat, which can be exploited for selective photothermal therapy of cancer (cancer cell death by heat generated in tumor tissue) [263, 264]. In addition, the unique optical properties of Au NPs make them a great candidate for the photodynamic therapy of cancer (the use of a drug that is activated by light to kill cancer cells) [265]. Gd based NPs have also shown great abilities in tumor growth inhibition [266], metastasis inhibition [267], and tumor-specifc magnetic resonance contrast enhancement [268]. Targeted drug delivery is also an important potential application of NPs. ZnO and $\mathrm { F e _ { 3 } O _ { 4 } N P s }$ were efciently used for targeted drug delivery and selective destruction of tumor cells [269–271].

Moreover, NPs have been successfully used in diferent medical applications such as cellular imaging [272], or in biosensors for DNA, carbohydrates, proteins, and heavy metal ions [273, 274], determination of blood glucose levels [275], and for medical diagnostics to detect bacteria [276] and viruses [277]. For instance, Au NPs were conjugated with SARS-CoV-2 antigens to rapidly detect the presence of SARS-CoV-2 IgM/IgA antibodies in blood samples within $1 0 { - } 1 5 \ \mathrm { m i n }$ [278], At the same time, due to their antimicrobial and antibacterial activities, NPs such as $\mathrm { T i O } _ { 2 } ,$ ZnO, $\mathrm { C u O } _ { \mathrm { i } }$ , and ${ \mathrm { B i V O } } _ { 4 }$ are being increasing used in various medical products such as catheters [279, 280].

# Applications in electronics

NPs, due to their novel electronic and optical properties, have a wide range of potential applications in imaging techniques and electronics. For instance, Gd-based NPs can improve the imaging quality and the contrast agent administration dose of magnetic resonance imaging (MRI). Te use of $\mathrm { G d } _ { 2 } \mathrm { O } _ { 3 }$ NPs as a contrasting agent was found to be more efcient than the commonly used agent (Gd-DOTA) at the same concentration [281]. At the same time, $\mathrm { G d P O _ { 4 } }$ NPs were successfully used for tumor detection using MRI in $1 / 1 0$ of the dose typically used with Gd-DTPA agent [282]. Interestingly, NPs also ofer the ability to image and track a single molecule, which can reveal important information about cellular processes such as membrane protein organization and interaction with other proteins. For example, $\mathrm { E u } ^ { 3 + }$ -doped oxide NPs were used to track a single toxin receptor with a localization precision of $3 0 \mathrm { n m }$ [283].

Regarding applications in batteries, an important component in lithium-ion batteries is the separators. Teir main function is to prevent the physical contact of anode and cathode, and to provide channels for the transport of ions. Te commonly used commercial material in battery separators, a polyolefn microporous membrane, sufers from poor electrolyte uptake and poor thermal stability [284]. Due to the aerogel structure of some NPs (such as $\mathrm { Z n O ~ N P s } )$ ), they are an ideal choice for separator plates in batteries [284]. Tis makes the batteries store a signifcantly higher amount of energy compared to traditional batteries. For lithium-air batteries, using Pt-Au bimetallic NPs strongly enhances oxygen reduction and oxygen evolution reactions [285]. Moreover, batteries made of nanocrystalline Ni and metal hydrides last longer and require less charging [23]. In addition to battery applications, several NPs such as CdS and ZnSe are also used in light-emitting diodes (LED) of modern displays to get higher brightness and bigger screens [23, 286]. Other

NPs such as CdTe NPs are also used in liquid crystal displays (LCDs) [287]. Te addition of a NP layer to LED and LCD enables them to generate more light using the same amount of energy and enhances their lifetime.

# Applications in agriculture

NPs have potential to beneft the agriculture feld by providing new solutions to current agricultural and environmental problems [288]. NPs are mainly used in two forms in agriculture, as nanofertilizers and nanopesticides. Chemical fertilizers have poor efciency due to leaching and volatilization. In these cases, the farmers usually react by using excessive amounts of fertilizers, which increases crops productivity but has an environmental cost [288]. In contrast, nanofertilizers are compounds that are applied in smaller amounts than regular chemical fertilizers but yet have better efciencies [289]. Te diference in efciency comes from the fact that they are able to release the nutrients just when and where they are required by the plants. In that way, they limit the conversion of excess amounts of fertilizer to gaseous forms or from leaking into the ground water [290]. Several NPs have been employed in the development of fertilizers, including $\mathrm { S i O } _ { 2 } ,$ , ${ \mathrm { Z n O } } _ { \mathrm { i } }$ , $\mathrm { C u O } _ { \mathrm { \it \cdot } }$ , Fe, and $\mathrm { M g \ N P s }$ [291–293]. Tese nanofertilizers provide the plants with increased nitrogen fxation, improved seed germination, amelioration to drought stress, increased seed weight, and increased photosynthesis ability [291–293]. Te large surface area and small size of these NPs are the main reasons for the better efciencies of nanofertilizers over conventional fertilizers [294].

Several NPs have proven antimicrobial, insecticidal, and nematicidal activities, which makes them a promising alternative to chemical pesticides and a potentially cheaper alternative to biopesticides [294]. For instance, the photocatalytic activity of $\mathrm { T i O } _ { 2 }$ NPs gives them a potent antimicrobial activity against Xanthomonas per‑ forans, the causing agent of tomato spot disease [295]. $\mathrm { { { C u O } } }$ NPs show insecticidal activity against Spodoptera littoralis, known as African cotton leafworm [296]. Ag NPs show nematicidal activity against Meloidogyne spp., root-knot nematodes [297].

# Applications in the food industry

NPs, despite toxological concerns, have impactful applications in several food industry-related process such as food production, preservation, and packaging. $\mathrm { T i O } _ { 2 }$ NPs are a major promising player in this industry. Teir photocatalytic antimicrobial activity makes them an interesting material for food packaging [298]. In addition, they are also used in sensors to detect volatile organic compounds [299]. Ag NPs are also promising in food packaging due to their antimicrobial activity. Tey play an important role in reducing the risk of pathogens and extending food shelf-life [294]. Te efciency of doping Ag and ZnO NPs to degradable and non-degradable packaging materials for meat, bread, fruit, and dairy products was tested against several yeast, molds, aerobic, and anaerobic bacteria [300]. For instance, polyvinyl chloride doped with Ag NPs was evaluated for packing minced meet at refrigerator temperature $( 4 ~ ^ { \circ } \mathrm { C } )$ ; the results showed that $\mathsf { A g N P s }$ signifcantly helped to slow down bacterial growth, increasing the shelf-life of minced meet from 2 to 7 days [301].

# Efects of NPs on biological systems

Although the use of NPs is exponentially growing, their possible toxicological and hazardous impacts to human health and environment cannot be ignored. NPs may get released to the environment during production stages, usage, recycling, or disposal. Tese NPs may persist in air, soil, water, or biological systems [302]. NPs can enter the human or animal body though the skin, orally, or via the respiratory tract, and afterwards move to other parts of the body. Te exposure to NPs was found to activate proinfammatory cytokines and chemokines with recruitment of infammatory cells, which impacts the immune system homeostasis and can lead to autoimmune, allergic, or neoplastic diseases [302]. Moreover, the exposure to ultrafne particles can cause pulmonary, cardiac, and central nervous system diseases [303–305]. Similarly, NPs can enter plants cells and cause harmful efects [306]. For instance, the exposure of $_ { \mathrm { Z n O } }$ and Al NPs was found to cause root growth inhibition in plants [307, 308].

# Conclusion

Nanoscience and nanotechnology are inherently transdisciplinary felds of science. With new bio-based approaches, there is a need for biologists to understand not only the basic principles of nanoscience, but also the technologies and methods traditionally employed to characterize nanomaterials. We hope that this review can help to inspire new collaborations across diferent scientifc disciplines, by helping biologists to identify the best technologies—and partners—to characterize their nanomaterials. At the same time, we recommend to take potential biological risks of these new materials into careful consideration already during the planning phase of such experiments.

# Abbreviations

AFM: Atomic force microscopy; BET: Brunauer–Emmett–Teller; BJH: Barrett– Joyner–Halenda; CV: Cyclic voltammetry; DLS: Dynamic light scattering; DLVO: Derjaguin–Landau–Verwey–Overbeek; DMA: Dynamic mechanical analysis; DMT: Derjaguin–Muller–Toporov; DRS: UV–vis difuse refectance spectroscopy; DSC: Diferential scanning calorimetry; DTA: Diferential thermal analysis; EDX: Energy-dispersive X-ray spectroscopy; EM: Electron microscopy; EPR:

Electron paramagnetic resonance spectroscopy; ESR: Electron spin resonance spectroscopy; FTIR: Fourier-transform infrared spectroscopy; HAADF: Highangle annular dark-feld imaging; ISO: International Organization for Standardization; JKR: Johnson–Kendall–Roberts; LCD: Liquid crystal display; LED: Lightemitting diode; LSPR: Localized surface plasmon resonance; MFM: Magnetic force microscopy; MRI: Magnetic resonance imaging; NPs: Nanoparticles; NTA: Nanoparticle tracking analysis; PL: Photoluminescence spectroscopy; rc: Critical radius; $\Gamma _ { \mathrm { { S p } } } \mathrm { { . } }$ Threshold radius for superparamagnetism; SAED: Selected area electron difraction; SEM: Scanning electron microscopy; SERS: Surfaceenhanced Raman spectroscopy; SPR: Surface plasmon resonance; SQUID: Superconducting quantum interference device; STEM: Scanning transmission electron microscopy; STM: Scanning tunneling microscopy; TEM: Transmission electron microscopy; TG/DTA: Thermogravimetry/diferential thermal analysis; TGA: Thermogravimetric analysis; THW: Transient hot wire; UTM: Universal testing machine; UV: Ultraviolet; UV–vis: Ultraviolet–visible spectroscopy; VSM: Vibrating-sample magnetometry; XPS: X-ray photoelectron spectroscopy; XRD: X-ray difraction analysis.

Acknowledgements Not applicable.

# Author contributions

NJ wrote the manuscript. DL edited the manuscript. Both the authors read and approved the fnal manuscript.

# Funding

This work was supported by the Research Council of Norway, Grant 294605 (Center for Digital Life) to DL.

Availability of data and materials Not applicable.

# Declarations

Ethics approval and consent to participate Not applicable.

Consent for publication Not applicable.

Competing interests The authors declare that they have no competing interests.

Received: 2 February 2022 Accepted: 23 May 2022   
Published online: O7 June 2022

# References

1. Buzea C, Pacheco II, Robbie K. Nanomaterials and nanoparticles: sources and toxicity. Biointerphases. 2007;2(4):MR17–71.   
2. Mulvaney P. Nanoscience vs nanotechnology—defning the feld. ACS Nano. 2015. https://doi.org/10.1021/acsnano.5b01418.   
3. Hasan S. A review on nanoparticles: their synthesis and types. Res J Recent Sci. 2015;2277:2502.   
4. Feynman RP. Plenty of room at the bottom. In: APS annual meeting. 1959.   
5. Tolochko NK. History of nanotechnology (Chapter 1). In: Kharkin V, Bai C, Kapitza S, Awadelkarim OO, editors. Nanoscience and nanotechnologies (vol. 1). ISBN 978-1-78021-531-0. https://www.eolss.net/ebooklib/ bookinfo/nanoscience-nanotechnologies.aspx   
6. Walter P, Welcomme E, Hallégot P, Zaluzec NJ, Deeb C, Castaing J, et al. Early use of PbS nanotechnology for an ancient hair dyeing formula. Nano Lett. 2006;6(10):2215–9.   
7. Barber DJ, Freestone IC. An investigation of the origin of the colour of the Lycurgus Cup by analytical transmission electron microscopy. Archaeometry. 1990;32(1):33–45.   
8. Atwater HA. The promise of plasmonics. Sci Am. 2007;296(4):56–63.   
9. Brill RH, Cahill ND. A red opaque glass from Sardis and some thoughts on red opaques in general. J Glass Stud. 1988;30:16–27. http://www. jstor.org/stable/24190804   
10. Sharon M. History of nanotechnology: from prehistoric to modern times. New Jersey: Wiley; 2019.   
11. Bratovcic A. Diferent applications of nanomaterials and their impact on the environment. Int J Mater Sci Eng. 2019;5:1–7.   
12. Gajanan K, Tijare SN. Applications of nanomaterials. Mater Today Proc. 2018;5(1):1093–6.   
13. Khot LR, Sankaran S, Maja JM, Ehsani R, Schuster EW. Applications of nanomaterials in agricultural production and crop protection: a review. Crop Prot. 2012;35:64–70.   
14. Roduner E. Size matters: why nanomaterials are diferent. Chem Soc Rev. 2006;35(7):583–92.   
15. Lines MG. Nanomaterials for practical functional uses. J Alloys Compd. 2008;449(1–2):242–5.   
16. Gade A, Ingle A, Whiteley C, Rai M. Mycogenic metal nanoparticles: progress and applications. Biotechnol Lett. 2010;32(5):593–600.   
17. Ikhmayies SJ. Characterization of nanomaterials. JOM. 2014;66(1):28–9.   
18. Ashraf MA, Peng W, Zare Y, Rhee KY. Efects of size and aggregation/ agglomeration of nanoparticles on the interfacial/interphase properties and tensile strength of polymer nanocomposites. Nanoscale Res Lett. 2018;13(1):1–7.   
19. Suttiponparnit K, Jiang J, Sahu M, Suvachittanont S, Charinpanitkul T, Biswas P. Role of surface area, primary particle size, and crystal phase on titanium dioxide nanoparticle dispersion properties. Nanoscale Res Lett. 2011;6(1):1–8.   
20. Fubini B, Ghiazza M, Fenoglio I. Physico-chemical features of engineered nanoparticles relevant to their toxicity. Nanotoxicology. 2010;4(4):347–63.   
21. Geofrion LD, Guisbiers G. Quantum confnement: size on the grill! J Phys Chem Solids. 2020;140: 109320.   
22. Kolahalam LA, Viswanath IVK, Diwakar BS, Govindh B, Reddy V, Murthy YLN. Review on nanomaterials: synthesis and applications. Mater Today Proc. 2019;18:2182–90.   
23. Ealia SAM, Saravanakumar MP. A review on the classifcation, characterisation, synthesis of nanoparticles and their application. In: IOP Conference Series: Materials Science and Engineering. IOP Publishing; 2017. p. 32019.   
24. Machado S, Pacheco JG, Nouws HPA, Albergaria JT, Delerue-Matos C. Characterization of green zero-valent iron nanoparticles produced with tree leaf extracts. Sci Total Environ. 2015;533:76–81.   
25. Khan I, Saeed K, Khan I. Nanoparticles: properties, applications and toxicities. Arab J Chem. 2019;12(7):908–31.   
26. Pan K, Zhong Q. Organic nanoparticles in foods: fabrication, characterization, and utilization. Annu Rev Food Sci Technol. 2016;7:245–66.   
27. Ng KK, Zheng G. Molecular interactions in organic nanoparticles for phototheranostic applications. Chem Rev. 2015;115(19):11012–42.   
28. Gujrati M, Malamas A, Shin T, Jin E, Sun Y, Lu Z-R. Multifunctional cationic lipid-based nanoparticles facilitate endosomal escape and reduction-triggered cytosolic siRNA release. Mol Pharm. 2014;11(8):2734–44.   
29. Long CM, Nascarella MA, Valberg PA. Carbon black vs black carbon and other airborne materials containing elemental carbon: physical and chemical distinctions. Environ Pollut. 2013;181:271–86.   
30. Dresselhaus MS, Dresselhaus G, Eklund PC. Fullerenes. J Mater Res. 1993;8(8):2054–97.   
31. Yuan X, Zhang X, Sun L, Wei Y, Wei X. Cellular toxicity and immunological efects of carbon-based nanomaterials. Part Fibre Toxicol. 2019;16(1):1–27.   
32. Lu K-Q, Quan $\mathrm { \Delta Q }$ Zhang N, Xu Y-J. Multifarious roles of carbon quantum dots in heterogeneous photocatalysis. J Energy Chem. 2016;25(6):927–35.   
33. Mauter MS, Elimelech M. Environmental applications of carbon-based nanomaterials. Environ Sci Technol. 2008;42(16):5843–59.   
34. Oh W-K, Yoon H, Jang J. Size control of magnetic carbon nanoparticles for drug delivery. Biomaterials. 2010;31(6):1342–8.   
35. Liu M, Zhao F, Zhu D, Duan H, Lv Y, Li L, et al. Ultramicroporous carbon nanoparticles derived from metal–organic framework nanoparticles for high-performance supercapacitors. Mater Chem Phys. 2018;211:234–41.   
36. Chandra S, Das P, Bag S, Laha D, Pramanik P. Synthesis, functionalization and bioimaging applications of highly fuorescent carbon nanoparticles. Nanoscale. 2011;3(4):1533–40.   
37. Mochalin VN, Shenderova O, Ho D, Gogotsi Y. The properties and applications of nanodiamonds. Nat Nanotechnol. 2012;7(1):11–23.   
38. Ahlawat J, Asil SM, Barroso GG, Nurunnabi M, Narayan M. Application of carbon nano onions in the biomedical feld: recent advances and challenges. Biomater Sci. 2021. https://doi.org/10.1039/D0BM01476A.   
39. Toshima N, Yonezawa T. Bimetallic nanoparticles—novel materials for chemical and physical applications. New J Chem. 1998;22(11):1179–201.   
40. Nascimento MA, Cruz JC, Rodrigues GD, de Oliveira AF, Lopes RP. Synthesis of polymetallic nanoparticles from spent lithium-ion batteries and application in the removal of reactive blue 4 dye. J Clean Prod. 2018;202:264–72.   
41. Mody VV, Siwale R, Singh A, Mody HR. Introduction to metallic nanoparticles. J Pharm Bioallied Sci. 2010;2(4):282.   
42. Fedlheim DL, Foss CA. Metal nanoparticles: synthesis, characterization, and applications. Boca Raton: CRC Press; 2001.   
43. Dreaden EC, Alkilany AM, Huang X, Murphy CJ, El-Sayed MA. The golden age: gold nanoparticles for biomedicine. Chem Soc Rev. 2012;41(7):2740–79.   
44. Gupta SM, Tripathi M. An overview of commonly used semiconductor nanoparticles in photocatalysis. High Energy Chem. 2012;46(1):1–9.   
45. Sun S, Murray CB, Weller D, Folks L, Moser A. Monodisperse FePt nanoparticles and ferromagnetic FePt nanocrystal superlattices. Science (80-). 2000;287(5460):1989–92.   
46. Thomas S, Kumar Mishra P, Talegaonkar S. Ceramic nanoparticles: fabrication methods and applications in drug delivery. Curr Pharm Des. 2015;21(42):6165–88.   
47. Moreno-Vega A-I, Gomez-Quintero T, Nunez-Anita R-E, Acosta-Torres L-S, Castaño V. Polymeric and ceramic nanoparticles in biomedical applications. J Nanotechnol. 2012. https://doi.org/10.1155/2012/ 936041.   
48. D’Amato R, Falconieri M, Gagliardi S, Popovici E, Serra E, Terranova G, et al. Synthesis of ceramic nanoparticles by laser pyrolysis: from research to applications. J Anal Appl Pyrolysis. 2013;104:461–9.   
49. Wu Q, Miao W, Gao H, Hui D. Mechanical properties of nanomaterials: a review. Nanotechnol Rev. 2020;9(1):259–73.   
50. Pithawalla YB, El-Shall MS, Deevi SC, Ström V, Rao KV. Synthesis of magnetic intermetallic FeAl nanoparticles from a non-magnetic bulk alloy. J Phys Chem B. 2001;105(11):2085–90.   
51. Keesom WH. On the deduction of the equation of state from Boltzmann’s entropy principle’. KNAW Proc. 1912;15:240–56.   
52. Debye P. Molecular forces and their electrical interpretation. Phys Zeitschrift. 1921;22:302–8.   
53. London F. The general theory of molecular forces. Trans Faraday Soc. 1937;33:8b–26.   
54. Guo D, Xie G, Luo J. Mechanical properties of nanoparticles: basics and applications. J Phys D Appl Phys. 2013;47(1):13001.   
55. Missana T, Adell A. On the applicability of DLVO theory to the prediction of clay colloids stability. J Colloid Interface Sci. 2000;230(1):150–6.   
56. Brant J, Lecoanet H, Wiesner MR. Aggregation and deposition characteristics of fullerene nanoparticles in aqueous systems. J Nanoparticle Res. 2005;7(4):545–53.   
57. Tan S, Sherman RL, Ford WT. Nanoscale compression of polymer microspheres by atomic force microscopy. Langmuir. 2004;20(17):7015–20.   
58. Armini S, Vakarelski IU, Whelan CM, Maex K, Higashitani K. nanoscale indentation of polymer and composite polymer−silica core−shell submicrometer particles by atomic force microscopy. Langmuir. 2007;23(4):2007–14.   
59. Savage T, Rao AM. Thermal properties of nanomaterials and nanocomposites. In: Thermal conductivity. Springer; 2004. p. 261–84.   
60. Andrievski RA. Review of thermal stability of nanomaterials. J Mater Sci. 2014;49(4):1449–60.   
61. Qiu L, Zhu N, Feng Y, Michaelides EE, Żyła $\mathsf { G } ,$ Jing D, et al. A review of recent advances in thermophysical properties at the nanoscale: from solid state to colloids. Phys Rep. 2020;843:1–81.   
62. Shima PD, Philip J, Raj B. Role of microconvection induced by Brownian motion of nanoparticles in the enhanced thermal conductivity of LDk   
63. Syam Sundar L, Sharma KV. Thermal conductivity enhancement of nanoparticles in distilled water. Int J Nanoparticles. 2008;1(1):66–77.   
64. Eastman JA, Choi SUS, Li S, Yu W, Thompson LJ. Anomalously increased efective thermal conductivities of ethylene glycol-based nanofuids containing copper nanoparticles. Appl Phys Lett. 2001;78(6):718–20.   
65. Zebarjadi M, Esfarjani K, Shakouri A, Bahk J-H, Bian Z, Zeng G, et al. Efect of nanoparticle scattering on thermoelectric power factor. Appl Phys Lett. 2009;94(20): 202105.   
66. Zeng G, Zide JMO, Kim W, Bowers JE, Gossard AC, Bian Z, et al. Crossplane Seebeck coefcient of Er As: In Ga As/In Ga Al As superlattices. J Appl Phys. 2007;101(3):34502.   
67. Kim W, Singer SL, Majumdar A, Vashaee D, Bian Z, Shakouri A, et al. Cross-plane lattice and electronic thermal conductivities of Er As: In Ga As∕ In Ga Al As superlattices. Appl Phys Lett. 2006;88(24):242107.   
68. Likhachev VN, Vinogradov GA, Alymov MI. Anomalous heat capacity of nanoparticles. Phys Lett A. 2006;357(3):236–9.   
69. Wang L, Tan Z, Meng S, Liang D, Li G. Enhancement of molar heat capacity of nanostructured $\mathsf { A l } _ { 2 } \mathsf { O } _ { 3 } .$ . J Nanoparticle Res. 2001;3(5):483–7.   
70. Wang L, Tan Z, Meng S, Druzhinina A, Varushchenko RA, Li G. Heat capacity enhancement and thermodynamic properties of nanostructured amorphous ${ \mathrm { S i O } } _ { 2 } .$ J Non Cryst Solids. 2001;296(1–2):139–42.   
71. Borel J-P. Thermodynamical size efect and the structure of metallic clusters. Surf Sci. 1981;106(1–3):1–9.   
72. Gülseren O, Ercolessi F, Tosatti E. Premelting of thin wires. Phys Rev B. 1995;51(11):7377.   
73. Shim J-H, Lee B-J, Cho YW. Thermal stability of unsupported gold nanoparticle: a molecular dynamics study. Surf Sci. 2002;512(3):262–8.   
74. Naitabdi A, Ono LK, Behafarid F, Cuenya BR. Thermal stability and segregation processes in self-assembled size-selected Au x Fe1-x nanoparticles deposited on $\mathrm { T i O } _ { 2 }$ (110): composition efects. J Phys Chem C. 2009;113(4):1433–46.   
75. Mottet C, Rossi G, Baletto F, Ferrando R. Single impurity efect on the melting of nanoclusters. Phys Rev Lett. 2005;95(3):35501.   
76. Cuenya BR. Synthesis and catalytic properties of metal nanoparticles: size, shape, support, composition, and oxidation state efects. Thin Solid Films. 2010;518(12):3127–50.   
77. Nealon GL, Donnio B, Greget R, Kappler J-P, Terazzi E, Gallani J-L. Magnetism in gold nanoparticles. Nanoscale. 2012;4(17):5244–58.   
78. Matthias BT, Clogston AM, Williams HJ, Corenzwit E, Sherwood RC. Ferromagnetism in solid solutions of Scandium and Indium. Phys Rev Lett. 1961;7(1):7.   
79. Matthias BT, Bozorth RM. Ferromagnetism of a zirconium–zinc compound. Phys Rev. 1958;109(2):604.   
80. Acker F, Fisk Z, Smith JL, Huang CY. Enhanced paramagnetism of TiBe2 and ferromagnetic transitions in TiBe2-xCux. J Magn Magn Mater. 1981;22(3):250–6.   
81. Hori H, Teranishi T, Nakae Y, Seino Y, Miyake M, Yamada S. Anomalous magnetic polarization efect of Pd and Au nano-particles. Phys Lett A. 1999;263(4–6):406–10.   
82. McCurrie RA. Ferromagnetic materials: structure and properties. Cambridge: Academic Press; 1994.   
83. Edelstein AS, Cammaratra RC. Nanomaterials: synthesis, properties and applications. Boca Raton: CRC Press; 1998.   
84. Jun Y, Seo J, Cheon J. Nanoscaling laws of magnetic nanoparticles and their applicabilities in biomedical sciences. Acc Chem Res. 2008;41(2):179–89.   
85. Skumryev V, Stoyanov S, Zhang Y, Hadjipanayis G, Givord D, Nogués J. Beating the superparamagnetic limit with exchange bias. Nature. 2003;423(6942):850–3.   
86. Kolhatkar AG, Jamison AC, Litvinov D, Willson RC, Lee TR. Tuning the magnetic properties of nanoparticles. Int J Mol Sci. 2013;14(8):15977–6009.   
87. Hu M, Butt H-J, Landfester K, Bannwarth MB, Wooh S, Thérien-Aubin H. Shaping the assembly of superparamagnetic nanoparticles. ACS Nano. 2019;13(3):3015–22.   
88. Marghussian V, Marghussian V. Nano-glass ceramics. Amsterdam: Elsevier; 2015.   
89. Kalubowilage M, Janik K, Bossmann SH. Magnetic nanomaterials for magnetically-aided drug delivery and hyperthermia. Appl Sci. 2019;9(14):2927. 90. Podaru G, Chikan V. Magnetism in nanomaterials: heat and force from colloidal magnetic particles. 2017; 91. Song Q, Zhang ZJ. Shape control and associated magnetic properties of spinel cobalt ferrite nanocrystals. J Am Chem Soc. 2004;126(19):6164–8.   
92. Salazar-Alvarez G, Qin J, Sepelak V, Bergmann I, Vasilakaki M, Trohidou KN, et al. Cubic versus spherical magnetic nanoparticles: the role of surface anisotropy. J Am Chem Soc. 2008;130(40):13234–9.   
93. Zhen G, Muir BW, Mofat BA, Harbour P, Murray KS, Moubaraki B, et al. Comparative study of the magnetic behavior of spherical and cubic superparamagnetic iron oxide nanoparticles. J Phys Chem C. 2011;115(2):327–34.   
94. Lee W, Kim MG, Choi J, Park J-I, Ko SJ, Oh SJ, et al. Redox-transmetalation process as a generalized synthetic strategy for core-shell magnetic nanoparticles. J Am Chem Soc. 2005;127(46):16090–7.   
95. Park J-I, Cheon J. Synthesis of “solid solution” and “core-shell” type cobalt–platinum magnetic nanoparticles via transmetalation reactions. J Am Chem Soc. 2001;123(24):5743–6.   
96. Lee J-H, Huh Y-M, Jun Y, Seo J, Jang J, Song H-T, et al. Artifcially engineered magnetic nanoparticles for ultra-sensitive molecular imaging. Nat Med. 2007;13(1):95–9.   
97. Kumbhakar P, Ray SS, Stepanov AL. Optical properties of nanoparticles and nanocomposites. Hindawi; 2014.   
98. Khlebtsov NG, Dykman LA. Optical properties and biomedical applications of plasmonic nanoparticles. J Quant Spectrosc Radiat Transf. 2010;111(1):1–35.   
99. Kelly KL, Coronado E, Zhao LL, Schatz GC. The optical properties of metal nanoparticles: the infuence of size, shape, and dielectric environment. Washington: ACS Publications; 2003.   
100. Kreibig U, Vollmer M. Theoretical considerations. In: Optical properties of metal clusters. Springer; 1995. p. 13–201.   
101. Duval Malinsky M, Kelly KL, Schatz GC, Van Duyne RP. Nanosphere lithography: efect of substrate on the localized surface plasmon resonance spectrum of silver nanoparticles. J Phys Chem B. 2001;105(12):2343–50.   
102. Jensen TR, Duval ML, Kelly KL, Lazarides AA, Schatz GC, Van Duyne RP. Nanosphere lithography: efect of the external dielectric medium on the surface plasmon resonance spectrum of a periodic array of silver nanoparticles. J Phys Chem B. 1999;103(45):9846–53.   
103. Rajan AR, Vilas V, Rajan A, John A, Philip D. Synthesis of nanostructured CeO2 by chemical and biogenic methods: optical properties and bioactivity. Ceram Int. 2020;46(9):14048–55.   
104. Fu L, Fu Z. Plectranthus amboinicus leaf extract-assisted biosynthesis of ZnO nanoparticles and their photocatalytic activity. Ceram Int. 2015;41(2):2492–6.   
105. Cuenya BR, Baeck S-H, Jaramillo TF, McFarland EW. Size-and supportdependent electronic and catalytic properties of Au0/Au3+ nanoparticles synthesized from block copolymer micelles. J Am Chem Soc. 2003;125(42):12928–34.   
106. Shaikhutdinov SK, Meyer R, Naschitzki M, Bäumer M, Freund H-J. Size and support efects for CO adsorption on gold model catalysts. Catal Lett. 2003;86(4):211–9.   
107. Lemire C, Meyer R, Shaikhutdinov S, Freund H. Do quantum size efects control CO adsorption on gold nanoparticles? Angew Chem Int Ed. 2004;43(1):118–21.   
108. Ono LK, Sudfeld D, Cuenya BR. In situ gas-phase catalytic properties of TiC-supported size-selected gold nanoparticles synthesized by diblock copolymer encapsulation. Surf Sci. 2006;600(23):5041–50.   
109. Lu Y, Chen W. Size efect of silver nanoclusters on their catalytic activity for oxygen electro-reduction. J Power Sources. 2012;197:107–10.   
110. Shao M, Peles A, Shoemaker K. Electrocatalysis on platinum nanoparticles: particle size efect on oxygen reduction reaction activity. Nano Lett. 2011;11(9):3714–9.   
111. Valden M, Lai X, Goodman DW. Onset of catalytic activity of gold clusters on titania with the appearance of nonmetallic properties. Science (80-). 1998;281(5383):1647–50.   
112. Zhang P, Sham TK. X-ray studies of the structure and electronic behavior of alkanethiolate-capped gold nanoparticles: the interplay of size and surface efects. Phys Rev Lett. 2003;90(24): 245502.   
113. Haruta M. Nanoparticulate gold catalysts for low-temperature CO oxidation. ChemInform. 2004. https://doi.org/10.1002/chin.200448226.   
114. Xu R, Wang D, Zhang J, Li Y. Shape-dependent catalytic activity of silver nanoparticles for the oxidation of styrene. Chem Asian J. 2006;1(6):888–93.   
115. Henry CR. Morphology of supported nanoparticles. Prog Surf Sci. 2005;80(3–4):92–116.   
116. Humbert MP, Murillo LE, Chen JG. Rational design of platinum-based bimetallic catalysts with enhanced hydrogenation activity. ChemPhysChem. 2008;9(9):1262–4.   
117. Toda T, Igarashi H, Uchida H, Watanabe M. Enhancement of the electroreduction of oxygen on Pt alloys with Fe, Ni, and Co. J Electrochem Soc. 1999;146(10):3750.   
118. Igarashi H, Fujino T, Zhu Y, Uchida H, Watanabe M. CO tolerance of Pt alloy electrocatalysts for polymer electrolyte fuel cells and the detoxifcation mechanism. Phys Chem Chem Phys. 2001;3(3):306–14.   
119. Croy JR, Mostafa S, Hickman L, Heinrich H, Cuenya BR. Bimetallic PtMetal catalysts for the decomposition of methanol: efect of secondary metal on the oxidation state, activity, and selectivity of Pt. Appl Catal A Gen. 2008;350(2):207–16.   
120. Liu P, Nørskov JK. Ligand and ensemble efects in adsorption on alloy surfaces. Phys Chem Chem Phys. 2001;3(17):3814–8.   
121. Carlsson AF, Naschitzki M, Bäumer M, Freund H-J. The structure and reactivity of $\mathsf { A l } _ { 2 } \mathsf { O } _ { 3 }$ -supported cobalt–palladium particles: a CO-TPD, STM, and XPS study. J Phys Chem B. 2003;107(3):778–85.   
122. Besenbacher F, Chorkendorf I, Clausen BS, Hammer B, Molenbroek AM, Nørskov JK, et al. Design of a surface alloy catalyst for steam reforming. Science. 1998;279(5358):1913–5.   
123. Ono LK, Roldan-Cuenya B. Efect of interparticle interaction on the low temperature oxidation of CO over size-selected Au nanocatalysts supported on ultrathin TiC flms. Catal Lett. 2007;113(3):86–94.   
124. Knapp M, Crihan D, Seitsonen AP, Over H. Hydrogen transfer reaction on the surface of an oxide catalyst. J Am Chem Soc. 2005;127(10):3236–7.   
125. Hendriksen BLM, Frenken JWM. CO oxidation on Pt (110): scanning tunneling microscopy inside a high-pressure fow reactor. Phys Rev Lett. 2002;89(4):46101.   
126. Gong X-Q, Raval R, Hu P. General insight into CO oxidation: a density functional theory study of the reaction mechanism on platinum oxides. Phys Rev Lett. 2004;93(10): 106104.   
127. Gong X-Q, Liu Z-P, Raval R, Hu P. A systematic study of CO oxidation on metals and metal oxides: density functional theory calculations. J Am Chem Soc. 2004;126(1):8–9.   
128. Over H, Seitsonen AP. Oxidation of metal surfaces. Science (80-). 2002;297(5589):2003–5.   
129. Yoon B, Häkkinen H, Landman U, Wörz AS, Antonietti J-M, Abbet S, et al. Charging efects on bonding and catalyzed oxidation of CO on Au8 clusters on MgO. Science (80-). 2005;307(5708):403–7.   
130. Laursen S, Linic S. Oxidation catalysis by oxide-supported Au nanostructures: the role of supports and the efect of external conditions. Phys Rev Lett. 2006;97(2):26101.   
131. Rodriguez JA, Wang X, Liu P, Wen W, Hanson JC, Hrbek J, et al. Gold nanoparticles on ceria: importance of O vacancies in the activation of gold. Top Catal. 2007;44(1–2):73–81.   
132. Yan W, Chen B, Mahurin SM, Dai S, Overbury SH. Brookite-supported highly stable gold catalytic system for CO oxidation. Chem Commun. 2004;17:1918–9.   
133. Rodriguez JA, Liu P, Viñes F, Illas F, Takahashi Y, Nakamura K. Dissociation of SO2 on Au/TiC (001): efects of Au–C interactions and charge polarization. Angew Chemie. 2008;120(35):6787–91.   
134. Vladár AE, Hodoroaba V-D. Characterization of nanoparticles by scanning electron microscopy. In: Characterization of nanoparticles. Elsevier; 2020. p. 7–27.   
135. Kano S, Tada T, Majima Y. Nanoparticle characterization based on STM and STS. Chem Soc Rev. 2015;44(4):970–87.   
136. Kumar A, Dixit CK. Methods for characterization of nanoparticles. In: Advances in nanomedicine for the delivery of therapeutic nucleic acids. Elsevier; 2017. p. 43–58.   
137. Kouvaris P, Delimitis A, Zaspalis V, Papadopoulos D, Tsipas SA, Michailidis N. Green synthesis and characterization of silver nanoparticles produced using Arbutus unedo leaf extract. Mater Lett. 2012;76:18–20.   
138. Song JY, Kim BS. Rapid biological synthesis of silver nanoparticles using plant leaf extracts. Bioprocess Biosyst Eng. 2009;32(1):79–84.   
139. Hungund BS, Dhulappanavar GR, Ayachit NH. Comparative evaluation of antibacterial activity of silver nanoparticles biosynthesized using fruit juices. J Nanomed Nanotechnol. 2015;6(2):1.   
140. Li Z, Wang Y, Shen J, Liu W, Sun X. The measurement system of nanoparticle size distribution from dynamic light scattering data. Opt Lasers Eng. 2014;56:94–8.   
141. Raval N, Maheshwari R, Kalyane D, Youngren-Ortiz SR, Chougule MB, Tekade RK. Importance of physicochemical characterization of nanoparticles in pharmaceutical product development. In: Basic fundamentals of drug delivery. Elsevier; 2019. p. 369–400.   
142. Tripathi RM, Gupta RK, Shrivastav A, Singh MP, Shrivastav BR, Singh P. Trichoderma koningii assisted biogenic synthesis of silver nanoparticles and evaluation of their antibacterial activity. Adv Nat Sci Nanosci Nanotechnol. 2013;4(3):35005.   
143. Roy K, Sarkar CK, Ghosh CK. Photocatalytic activity of biogenic silver nanoparticles synthesized using potato (Solanum tuberosum) infusion. Spectrochim Acta Part A Mol Biomol Spectrosc. 2015;146:286–91.   
144. Soldatova AV, Balakrishnan G, Oyerinde OF, Romano CA, Tebo BM, Spiro TG. Biogenic and synthetic $\mathsf { M n O } _ { 2 }$ nanoparticles: size and growth probed with absorption and Raman spectroscopies and dynamic light scattering. Environ Sci Technol. 2019;53(8):4185–97.   
145. Filipe V, Hawe A, Jiskoot W. Critical evaluation of nanoparticle tracking analysis (NTA) by NanoSight for the measurement of nanoparticles and protein aggregates. Pharm Res. 2010;27(5):796–810.   
146. Gross J, Sayle S, Karow AR, Bakowsky U, Garidel P. Nanoparticle tracking analysis of particle size and concentration detection in suspensions of polymer and protein samples: infuence of experimental and data evaluation parameters. Eur J Pharm Biopharm. 2016;104:30–41.   
147. Rodrigues MC, Rolim WR, Viana MM, Souza TR, Gonçalves F, Tanaka CJ, et al. Biogenic synthesis and antimicrobial activity of silica-coated silver nanoparticles for esthetic dental applications. J Dent. 2020;96: 103327.   
148. Moreno-Martin G, Pescuma M, Pérez-Corona T, Mozzi F, Madrid Y. Determination of size and mass-and number-based concentration of biogenic SeNPs synthesized by lactic acid bacteria by using a multimethod approach. Anal Chim Acta. 2017;992:34–41.   
149. Naderi M. Surface area: Brunauer–Emmett–Teller (BET). In: Progress in fltration and separation. Elsevier; 2015. p. 585–608.   
150. Balaji S, Mandal BK, Vinod Kumar Reddy L, Sen D. Biogenic ceria nanoparticles (CeO2 NPs) for efective photocatalytic and cytotoxic activity. Bioengineering. 2020;7(1):26.   
151. Sankar S, Sharma SK, Kim DY. Synthesis and characterization of mesoporous ${ \mathsf { S i O } } _ { 2 }$ nanoparticles synthesized from biogenic rice husk ash for optoelectronic applications. Int J Eng Sci. 2016;17(1):353–8.   
152. Aher YB, Jain GH, Patil GE, Savale AR, Ghotekar SK, Pore DM, et al. Biosynthesis of copper oxide nanoparticles using leaves extract of Leucaena leucocephala L. and their promising upshot against diverse pathogens. Int J Mol Clin Microbiol. 2017;7(1):776–86.   
153. Ghotekar S, Pansambal S, Pawar SP, Pagar T, Oza R, Bangale S. Biological activities of biogenically synthesized fuorescent silver nanoparticles using Acanthospermum hispidum leaves extract. SN Appl Sci. 2019;1(11):1–12.   
154. Bardestani R, Patience GS, Kaliaguine S. Experimental methods in chemical engineering: specifc surface area and pore size distribution measurements—BET, BJH, and DFT. Can J Chem Eng. 2019;97(11):2781–91.   
155. Gelb LD, Gubbins KE. Pore size distributions in porous glasses: a computer simulation study. Langmuir. 1999;15(2):305–8.   
156. Epp J. X-ray difraction (XRD) techniques for materials characterization. In: Materials characterization using nondestructive evaluation (NDE) methods. Elsevier; 2016. p. 81–124.   
157. Hazarika M, Borah D, Bora P, Silva AR, Das P. Biogenic synthesis of palladium nanoparticles and their applications as catalyst and antimicrobial agent. PLoS ONE. 2017;12(9): e0184936.   
158. Groarke R, Vijayaraghavan RK, Powell D, Rennie A, Brabazon D. Powder characterization—methods, standards, and state of the art. In: Fundamentals of laser powder bed fusion of metals. Elsevier; 2021. p. 491–527.   
159. Nasrollahzadeh M, Atarod M, Sajjadi M, Sajadi SM, Issaabadi Z. Plantmediated green synthesis of nanostructures: mechanisms, characterization, and applications. In: Interface science and technology. Elsevier; 2019. p. 199–322.   
160. Goldstein JI, Newbury DE, Michael JR, Ritchie NWM, Scott JHJ, Joy DC. Scanning electron microscopy and X-ray microanalysis. Cham: Springer; 2017.   
161. Balasubramanian S, Kala SMJ, Pushparaj TL. Biogenic synthesis of gold nanoparticles using Jasminum auriculatum leaf extract and their catalytic, antimicrobial and anticancer activities. J Drug Deliv Sci Technol. 2020;57: 101620.   
162. Khan M, Khan M, Kuniyil M, Adil SF, Al-Warthan A, Alkhathlan HZ, et al. Biogenic synthesis of palladium nanoparticles using Pulicaria glutinosa extract and their catalytic activity towards the Suzuki coupling reaction. Dalt Trans. 2014;43(24):9026–31.   
163. Barabadi H, Kobarfard F, Vahidi H. Biosynthesis and characterization of biogenic tellurium nanoparticles by using Penicillium chrysogenum PTCC 5031: a novel approach in gold biotechnology. Iran J Pharm Res IJPR. 2018;17(Suppl2):87.   
164. Fayaz M, Tiwary CS, Kalaichelvan PT, Venkatesan R. Blue orange light emission from biogenic synthesized silver nanoparticles using Trichoderma viride. Colloids Surf B Biointerfaces. 2010;75(1):175–8.   
165. Otten MT. High-Angle annular dark-feld imaging on a tem/stem system. J Electron Microsc Tech. 1991;17(2):221–30.   
166. Utsunomiya S, Ewing RC. Application of high-angle annular dark feld scanning transmission electron microscopy, scanning transmission electron microscopy-energy dispersive X-ray spectrometry, and energyfltered transmission electron microscopy to the characterization of nanopar. Environ Sci Technol. 2003;37(4):786–91.   
167. Haverkamp RG, Marshall AT, van Agterveld D. Pick your carats: nanoparticles of gold–silver–copper alloy produced in vivo. J Nanoparticle Res. 2007;9(4):697–700.   
168. Hossain M, Polash SA, Takikawa M, Shubhra RD, Saha T, Islam Z, et al. Investigation of the antibacterial activity and in vivo cytotoxicity of biogenic silver nanoparticles as potent therapeutics. Front Bioeng Biotechnol. 2019;7:239.   
169. Kimber RL, Lewis EA, Parmeggiani F, Smith K, Bagshaw H, Starborg T, et al. Biosynthesis and characterization of copper nanoparticles using Shewanella oneidensis: application for click chemistry. Small. 2018;14(10):1703145.   
170. Fadley CS. X-ray photoelectron spectroscopy: progress and perspectives. J Electron Spectros Relat Phenomena. 2010;178:2–32.   
171. Lykhach Y, Kozlov SM, Skála T, Tovt A, Stetsovych V, Tsud N, et al. Counting electrons on supported nanoparticles. Nat Mater. 2016;15(3):284–8.   
172. Sneha K, Sathishkumar M, Lee SY, Bae MA, Yun Y-S. Biosynthesis of Au nanoparticles using cumin seed powder extract. J Nanosci Nanotechnol. 2011;11(2):1811–4.   
173. Aygun A, Gülbagca F, Ozer LY, Ustaoglu B, Altunoglu YC, Baloglu MC, et al. Biogenic platinum nanoparticles using black cumin seed and their potential usage as antimicrobial and anticancer agent. J Pharm Biomed Anal. 2020;179: 112961.   
174. Gulbagca F, Ozdemir S, Gulcan M, Sen F. Synthesis and characterization of Rosa canina-mediated biogenic silver nanoparticles for antioxidant, antibacterial, antifungal, and DNA cleavage activities. Heliyon. 2019;5(12): e02980.   
175. Huo Y-C, Li W-W, Chen C-B, Li C-X, Zeng R, Lau T-C, et al. Biogenic FeS accelerates reductive dechlorination of carbon tetrachloride by Shewanella putrefaciens CN32. Enzyme Microb Technol. 2016;95:236–41.   
176. Manor J, Feldblum ES, Zanni MT, Arkin IT. Environment polarity in proteins mapped noninvasively by FTIR spectroscopy. J Phys Chem Lett. 2012;3(7):939–44.   
177. Deepty M, Srinivas C, Kumar ER, Mohan NK, Prajapat CL, Rao TVC, et al. XRD, EDX, FTIR and ESR spectroscopic studies of co-precipitated Mnsubstituted Zn–ferrite nanoparticles. Ceram Int. 2019;45(6):8037–44.   
178. Chevali V, Kandare E. Rigid biofoam composites as eco-efcient construction materials. In: Biopolymers and biotech admixtures for ecoefcient construction materials. Elsevier; 2016. p. 275–304.   
179. Składanowski M, Golinska P, Rudnicka K, Dahm H, Rai M. Evaluation of cytotoxicity, immune compatibility and antibacterial activity of biogenic silver nanoparticles. Med Microbiol Immunol. 2016;205(6):603–13.   
180. Tugarova AV, Mamchenkova PV, Dyatlova YA, Kamnev AA. FTIR and Raman spectroscopic studies of selenium nanoparticles synthesised by the bacterium Azospirillum thiophilum. Spectrochim Acta Part A Mol Biomol Spectrosc. 2018;192:458–63.   
181. Sikora A, Bartczak D, Geißler D, Kestens V, Roebben G, Ramaye Y, et al. A systematic comparison of diferent techniques to determine the zeta potential of silica nanoparticles in biological medium. Anal methods. 2015;7(23):9835–43.   
182. Gavade NL, Kadam AN, Suwarnkar MB, Ghodake VP, Garadkar KM. Biogenic synthesis of multi-applicative silver nanoparticles by using Ziziphus jujuba leaf extract. Spectrochim Acta Part A Mol Biomol Spectrosc. 2015;136:953–60.   
183. Edison TJI, Sethuraman MG. Biogenic robust synthesis of silver nanoparticles using Punica granatum peel and its application as a green catalyst for the reduction of an anthropogenic pollutant 4-nitrophenol. Spectrochim Acta Part A Mol Biomol Spectrosc. 2013;104:262–4.   
184. Ballottin D, Fulaz S, Souza ML, Corio P, Rodrigues AG, Souza AO, et al. Elucidating protein involvement in the stabilization of the biogenic silver nanoparticles. Nanoscale Res Lett. 2016;11(1):1–9.   
185. Fayaz AM, Balaji K, Girilal M, Yadav R, Kalaichelvan PT, Venketesan R. Biogenic synthesis of silver nanoparticles and their synergistic efect with antibiotics: a study against gram-positive and gram-negative bacteria. Nanomed Nanotechnol Biol Med. 2010;6(1):103–9.   
186. Menon S, KS SD, Agarwal H, Shanmugam VK. Efcacy of biogenic selenium nanoparticles from an extract of ginger towards evaluation on anti-microbial and anti-oxidant activities. Colloid Interface Sci Commun. 2019;29:1–8. https://doi.org/10.1016/j.colcom.2018.12.004   
187. Chooto P. Cyclic voltammetry and its applications. In: Voltammetry. IntechOpen; 2019. p. 1.   
188. Saw EN, Grasmik V, Rurainsky C, Epple M, Tschulik K. Electrochemistry at single bimetallic nanoparticles—using nano impacts for sizing and compositional analysis of individual AgAu alloy nanoparticles. Faraday Discuss. 2016;193:327–38.   
189. Testolin A, Cattaneo S, Wang W, Wang D, Piferi V, Prati L, et al. Cyclic voltammetry characterization of Au, Pd, and AuPd nanoparticles supported on diferent carbon nanofbers. Surfaces. 2019;2(1):205–15.   
190. Khan AU, Wei Y, Khan ZUH, Tahir K, Khan SU, Ahmad A, et al. Electrochemical and antioxidant properties of biogenic silver nanoparticles. Int J Electrochem Sci. 2015;10(10):7905–16.   
191. Roy N, Mondal S, Laskar RA, Basu S, Mandal D, Begum NA. Biogenic synthesis of Au and Ag nanoparticles by Indian propolis and its constituents. Colloids Surf B Biointerfaces. 2010;76(1):317–25.   
192. Long DA. Raman spectroscopy. New York. 1977;1.   
193. Huang M, Yan H, Chen C, Song D, Heinz TF, Hone J. Phonon softening and crystallographic orientation of strained graphene studied by Raman spectroscopy. Proc Natl Acad Sci. 2009;106(18):7304–8.   
194. Lin T, Song Y-L, Liao J, Liu F, Zeng T-T. Applications of surfaceenhanced Raman spectroscopy in detection felds. Nanomedicine. 2020;15(30):2971–89.   
195. Prasad C, Yuvaraja G, Venkateswarlu P. Biogenic synthesis of $\mathsf { F e } _ { 3 } \mathsf { O } _ { 4 }$ magnetic nanoparticles using Pisum sativum peels extract and its efect on magnetic and methyl orange dye degradation studies. J Magn Magn Mater. 2017;424:376–81.   
196. Anghel L, Balasoiu M, Ishchenko LA, Stolyar S V, Kurkin TS, Rogachev A V, et al. Characterization of bio-synthesized nanoparticles produced by Klebsiella oxytoca. In: Journal of Physics: Conference Series. IOP Publishing; 2012. p. 12005.   
197. Lahr RH, Vikesland PJ. Surface-enhanced Raman spectroscopy (SERS) cellular imaging of intracellulary biosynthesized gold nanoparticles. ACS Sustain Chem Eng. 2014;2(7):1599–608.   
198. Skoog DA, Holler FJ, Crouch SR, editors. Principles of instrumental analysis (7th edn). Boston, USA: Cengage learning; 2017. ISBN 978-1-305-57721-3   
199. Patel S, Patel P, Undre SB, Pandya SR, Singh M, Bakshi S. DNA binding and dispersion activities of titanium dioxide nanoparticles with UV/vis spectrophotometry, fuorescence spectroscopy and physicochemical analysis at physiological temperature. J Mol Liq. 2016;213:304–11.   
200. Al-Hakkani MF. Biogenic copper nanoparticles and their applications: a review. SN Appl Sci. 2020;2(3):1–20.   
201. Harne S, Sharma A, Dhaygude M, Joglekar S, Kodam K, Hudlikar M. Novel route for rapid biosynthesis of copper nanoparticles using aqueous extract of Calotropis procera L. latex and their cytotoxicity on tumor cells. Colloids Surf B Biointerfaces. 2012;95:284–8.   
202. Ismail M, Gul S, Khan MI, Khan MA, Asiri AM, Khan SB. Green synthesis of zerovalent copper nanoparticles for efcient reduction of toxic azo dyes congo red and methyl orange. Green Process Synth. 2019;8(1):135–43.   
203. Hassanien R, Husein DZ, Al-Hakkani MF. Biosynthesis of copper nanoparticles using aqueous Tilia extract: antimicrobial and anticancer activities. Heliyon. 2018;4(12): e01077.   
204. Suresh Y, Annapurna S, Bhikshamaiah G, Singh AK. Green luminescent copper nanoparticles. In: IOP Conference Series: Materials Science and Engineering. IOP Publishing; 2016. p. 12187.   
205. Zhang P, Hong RY, Chen Q, Feng WG. On the electrical conductivity and photocatalytic activity of aluminum-doped zinc oxide. Powder Technol. 2014;253:360–7.   
206. Karthik K, Vijayalakshmi S, Phuruangrat A, Revathi V, Verma U. Multifunctional applications of microwave-assisted biogenic $\mathrm { T i O } _ { 2 }$ nanoparticles. J Clust Sci. 2019;30(4):965–72.   
207. Jayabalan J, Mani G, Krishnan N, Pernabas J, Devadoss JM, Jang HT. Green biogenic synthesis of zinc oxide nanoparticles using Pseudomonas putida culture and its In vitro antibacterial and anti-bioflm activity. Biocatal Agric Biotechnol. 2019;21: 101327.   
208. Gawade VV, Gavade NL, Shinde HM, Babar SB, Kadam AN, Garadkar KM. Green synthesis of ZnO nanoparticles by using Calotropis procera leaves for the photodegradation of methyl orange. J Mater Sci Mater Electron. 2017;28(18):14033–9.   
209. Tompkins H, Irene EA. Handbook of ellipsometry. William Andrew; 2005.   
210. Losurdo M, Bergmair M, Bruno G, Cattelan D, Cobet C, de Martino A, et al. Spectroscopic ellipsometry and polarimetry for materials and systems analysis at the nanometer scale: state-of-the-art, potential, and perspectives. J Nanoparticle Res. 2009;11(7):1521–54.   
211. Moirangthem RS, Yaseen MT, Wei P-K, Cheng J-Y, Chang Y-C. Enhanced localized plasmonic detections using partially-embedded gold nanoparticles and ellipsometric measurements. Biomed Opt Express. 2012;3(5):899–910.   
212. Lakhwani G, Roijmans RFH, Kronemeijer AJ, Gilot J, Janssen RAJ, Meskers SCJ. Probing charge carrier density in a layer of photodoped ZnO nanoparticles by spectroscopic ellipsometry. J Phys Chem C. 2010;114(35):14804–10.   
213. Claxton J, Joudeh N, Røyne A, Linke D, Mikheenko P. Sequential magnetic mapping of bacteria loaded with Pd-Fe nanoparticles. In: 2020 IEEE 10th International conference nanomaterials: applications & properties (NAP). IEEE; 2020. p. 1–5.   
214. Passeri D, Dong C, Reggente M, Angeloni L, Barteri M, Scaramuzzo FA, et al. Magnetic force microscopy: quantitative issues in biomaterials. Biomatter. 2014;4(1): e29507.   
215. Campaña AL, Joudeh N, Høyer H, Røyne A, Linke D, Mikheenko P. Probing van der Waals and magnetic forces in bacteria with magnetic nanoparticles. In: 2020 IEEE 10th International conference nanomaterials: applications & properties (NAP). IEEE; 2020. p. 01NSSA03-1.   
216. Körnig A, Hartmann MA, Teichert C, Fratzl P, Faivre D. Magnetic force imaging of a chain of biogenic magnetite and Monte Carlo analysis of tip–particle interaction. J Phys D Appl Phys. 2014;47(23): 235403.   
217. Albrecht M, Janke V, Sievers S, Siegner U, Schüler D, Heyen U. Scanning force microspy study of biogenic nanoparticles for medical applications. J Magn Magn Mater. 2005;290:269–71.   
218. Campaña AL, Joudeh N, Mikheenko P, Linke D. Magnetic decoration of Escherichia coli loaded with Palladium nanoparticles. In: 2021 IEEE 11th International conference nanomaterials: applications and properties (NAP). IEEE; 2021. p. 1–5.   
219. Foner S. Vibrating sample magnetometer. Rev Sci Instrum. 1956;27(7):548.   
220. Kirupakar BR, Vishwanath BA, Sree MP. Vibrating sample magnetometer and its application in characterisation of magnetic property of the anti cancer drug magnetic microspheres. Int J Pharm Drug Anal. 2016;4(5):227–33.   
221. Yadav VK, Fulekar MH. Biogenic synthesis of maghemite nanoparticles $( \mathsf { y } { \mathrm { - F } } \mathsf { e } _ { 2 } \mathsf { O } _ { 3 } )$ using Tridax leaf extract and its application for removal of fy ash heavy metals (Pb, Cd). Mater Today Proc. 2018;5(9):20704–10.   
222. Tovar GI, Briceño S, Suarez J, Flores S, González G. Biogenic synthesis of iron oxide nanoparticles using Moringa oleifera and chitosan and its evaluation on corn germination. Environ Nanotechnol Monit Manag. 2020;14: 100350.   
223. Sawicki M, Stefanowicz W, Ney A. Sensitive SQUID magnetometry for studying nanomagnetism. Semicond Sci Technol. 2011;26(6):64006.   
224. Colclough MS, Gough CE, Keene M, Muirhead CM, Thomas N, Abell JS, et al. Radio-frequency SQUID operation using a ceramic high-temperature superconductor. Nature. 1987;328(6125):47–8.   
225. Enpuku K, Minotani T, Gima T, Kuroki Y, Itoh Y, Yamashita M, et al. Detection of magnetic nanoparticles with superconducting quantum interference device (SQUID) magnetometer and application to immunoassays. Jpn J Appl Phys. 1999;38(10A):L1102.   
226. Lingamdinne LP, Chang Y-Y, Yang J-K, Singh J, Choi E-H, Shiratani M, et al. Biogenic reductive preparation of magnetic inverse spinel iron oxide nanoparticles for the adsorption removal of heavy metals. Chem Eng J. 2017;307:74–84.   
227. Byrne JM, Coker VS, Cespedes E, Wincott PL, Vaughan DJ, Pattrick RAD, et al. Biosynthesis of zinc substituted magnetite nanoparticles with enhanced magnetic properties. Adv Funct Mater. 2014;24(17):2518–29.   
228. Atherton NM, Davies MJ, Gilbert BC. Electron spin resonance. Vol. 14. Royal Society of Chemistry; 1994.   
229. Flores-Arias Y, Vázquez-Victorio G, Ortega-Zempoalteca R, AcevedoSalas U, Ammar S, Valenzuela R. Magnetic phase transitions in ferrite nanoparticles characterized by electron spin resonance. J Appl Phys. 2015;117(17):17A503.   
230. Rubinstein M, Kodama RH, Makhlouf SA. Electron spin resonance study of NiO antiferromagnetic nanoparticles. J Magn Magn Mater. 2001;234(2):289–93.   
231. Nasibova A, Khalilov R, Abiyev H, Trubitsin B, Eftekhari A. Identifcation of the EPR signals of fg leaves (Ficus carica L.). Eurasian Chem Commun. 2021;3(3):193–9.   
232. Dixit R, Gupta A, Jordan N, Zhou S, Schild D, Weiss S, et al. Magnetic properties of biogenic selenium nanomaterials. Environ Sci Pollut Res. 2021. https://doi.org/10.1007/s11356-020-11683-2.   
233. Charsley EL, Laye PG, Palakollu V, Rooney JJ, Joseph B. DSC studies on organic melting point temperature standards. Thermochim Acta. 2006;446(1–2):29–32.   
234. Horiuchi K. DSC studies on structural phase transitions and molecular motions in some A2MCl4 compounds. Phys Status Solidi. 2004;201(4):723–6.   
235. Wang J, Xie H, Guo Z, Guan L, Li Y. Improved thermal properties of parafn wax by the addition of $\mathrm { T i O } _ { 2 }$ nanoparticles. Appl Therm Eng. 2014;73(2):1541–7.   
236. Illers K-H, Kanig G. Heat of fusion and lamellar structure of polyethylene single crystal mats. Colloid Polym Sci. 1982;260(6):564–9.   
237. Pérez-Alonso C, Cruz-Olivares J, Barrera-Pichardo JF, Rodríguez-Huezo ME, Báez-González JG, Vernon-Carter EJ. DSC thermo-oxidative stability of red chili oleoresin microencapsulated in blended biopolymers matrices. J Food Eng. 2008;85(4):613–24.   
238. Ontong JC, Singh S, Nwabor OF, Chusri S, Voravuthikunchai SP. Potential of antimicrobial topical gel with synthesized biogenic silver nanoparticle using Rhodomyrtus tomentosa leaf extract and silk sericin. Biotechnol Lett. 2020;42(12):2653–64.   
239. Ahsan A, Farooq MA, Ahsan Bajwa A, Parveen A. Green synthesis of silver nanoparticles using Parthenium hysterophorus: optimization, characterization and in vitro therapeutic evaluation. Molecules. 2020;25(15):3324.   
240. Tanzi MC, Farè S, Candiani G. Foundations of biomaterials engineering. Cambridge: Academic Press; 2019.   
241. Thomas S, Thomas R, Zachariah AK, Kumar R. Thermal and rheological measurement techniques for nanomaterials characterization, vol. 3. Amsterdam: Elsevier; 2017.   
242. Song P, Wen D, Guo ZX, Korakianitis T. Oxidation investigation of nickel nanoparticles. Phys Chem Chem Phys. 2008;10(33):5057–65.   
243. Wagner M. Thermal analysis in practice. Munich, Germany: Hanser Publications; 2009. ISBN 978-1-56990-643-9   
244. Ajroudi L, Mliki N, Bessais L, Madigou V, Villain S, Leroux C. Magnetic, electric and thermal properties of cobalt ferrite nanoparticles. Mater Res Bull. 2014;59:49–58.   
245. Loganathan S, Valapa RB, Mishra RK, Pugazhenthi G, Thomas S. Thermogravimetric analysis for characterization of nanomaterials. In: Thermal and rheological measurement techniques for nanomaterials characterization. Elsevier; 2017. p. 67–108.   
246. Rami JM, Patel CD, Patel CM, Patel MV. Thermogravimetric analysis (TGA) of some synthesized metal oxide nanoparticles. Mater Today Proc. 2021;43:655–9.   
247. Pang LSK, Saxby JD, Chatfeld SP. Thermogravimetric analysis of carbon nanotubes and nanoparticles. J Phys Chem. 1993;97(27):6941–2.   
248. Saadatkhah N, Carillo Garcia A, Ackermann S, Leclerc P, Latif M, Samih S, et al. Experimental methods in chemical engineering: thermogravimetric analysis—TGA. Can J Chem Eng. 2020;98(1):34–43.   
249. Shah A, Lutfullah G, Ahmad K, Khalil AT, Maaza M. Daphne mucronatamediated phytosynthesis of silver nanoparticles and their novel biological applications, compatibility and toxicity studies. Green Chem Lett Rev. 2018;11(3):318–33.   
250. Nguyen TM-T, Huynh TT-T, Dang C-H, Mai D-T, Nguyen TT-N, Nguyen D-T, et al. Novel biogenic silver nanoparticles used for antibacterial efect and catalytic degradation of contaminants. Res Chem Intermed.   
2020;46(3):1975–90.   
251. Healy JJ, De Groot JJ, Kestin J. The theory of the transient hotwire method for measuring thermal conductivity. Physica $\mathsf { B } + \mathsf { C } .$   
1976;82(2):392–408.   
252. Kumari MM, Philip D. Synthesis of biogenic SnO2 nanoparticles and evaluation of thermal, rheological, antibacterial and antioxidant activities. Powder Technol. 2015;270:312–9.   
253. Rufus A, Sreeju N, Philip D. Synthesis of biogenic hematite (α-Fe 2 O   
3) nanoparticles for antibacterial and nanofuid applications. RSC Adv.   
2016;6(96):94206–17.   
254. Davis JR. Tensile testing. ASM international; 2004.   
255. Hernández-Gómora AE, Lara-Carrillo E, Robles-Navarro JB, ScougallVilchis RJ, Hernández-López S, Medina-Solís CE, et al. Biosynthesis of silver nanoparticles on orthodontic elastomeric modules: evaluation of mechanical and antibacterial properties. Molecules. 2017;22(9):1407.   
256. Batool S, Hussain Z, Niazi MBK, Liaqat U, Afzal M. Biogenic synthesis of silver nanoparticles and evaluation of physical and antimicrobial properties of Ag/PVA/starch nanocomposites hydrogel membranes for wound dressing application. J Drug Deliv Sci Technol. 2019;52:403–14.   
257. Schuh CA. Nanoindentation studies of materials. Mater Today.   
2006;9(5):32–40.   
258. Polishchuk I, Bracha AA, Bloch L, Levy D, Kozachkevich S, EtingerGeller Y, et al. Coherently aligned nanoparticles within a biogenic single crystal: a biological prestressing strategy. Science (80-).   
2017;358(6368):1294–8.   
259. Xuexia Z. Mechanical properties of silica cells in bamboo measured using in situ imaging nanoindentation. Wood Fiber Sci. 2016;48(4):1–6.   
260. Franck A, Germany TI. Viscoelasticity and dynamic mechanical testing. TA Instruments, New Castle, DE, USA AN004. 1993;   
261. Siripanth J, Wongwitthayakool P. Flexural strength and viscoelastic properties of acrylic resin denture base material containing silver nanoparticle synthesized from fngerroot aqueous extract. In: Key engineering materials. Trans Tech Publ; 2018. p. 178–82.   
262. Bettaieb F, Khiari R, Dufresne A, Mhenni MF, Belgacem MN. Mechanical and thermal properties of Posidonia oceanica cellulose nanocrystal reinforced polymer. Carbohydr Polym. 2015;123:99–104.   
263. Huang X, Jain PK, El-Sayed IH, El-Sayed MA. Gold nanoparticles: interesting optical properties and recent applications in cancer diagnostics and therapy. Nanomedicine. 2007. https://doi.org/10.2217/17435889.2.5.   
681.   
264. El-Sayed IH, Huang X, El-Sayed MA. Selective laser photo-thermal therapy of epithelial carcinoma using anti-EGFR antibody conjugated gold nanoparticles. Cancer Lett. 2006;239(1):129–35.   
265. Elahi N, Kamali M, Baghersad MH. Recent biomedical applications of gold nanoparticles: a review. Talanta. 2018;184:537–56.   
266. Chen C, Xing G, Wang J, Zhao Y, Li B, Tang J, et al. Multihydroxylated [Gd@ C82 (OH) 22] n nanoparticles: antineoplastic activity of high efciency and low toxicity. Nano Lett. 2005;5(10):2050–7.   
267. Meng H, Xing G, Blanco E, Song Y, Zhao L, Sun B, et al. Gadolinium metallofullerenol nanoparticles inhibit cancer metastasis through matrix metalloproteinase inhibition: imprisoning instead of poisoning cancer cells. Nanomed Nanotechnol Biol Med. 2012;8(2):136–46.   
268. Swanson SD, Kukowska-Latallo JF, Patri AK, Chen C, Ge S, Cao Z, et al. Targeted gadolinium-loaded dendrimer nanoparticles for tumorspecifc magnetic resonance contrast enhancement. Int J Nanomed.   
2008;3(2):201.   
269. Rasmussen JW, Martinez E, Louka P, Wingett DG. Zinc oxide nanoparticles for selective destruction of tumor cells and potential for drug delivery applications. Expert Opin Drug Deliv. 2010;7(9):1063–77.   
270. Chen F-H, Gao Q, Ni JZ. The grafting and release behavior of doxorubincin from $\mathsf { F e } _ { 3 } \mathsf { O } _ { 4 } @$ ${ \mathsf { S i O } } _ { 2 }$ core–shell structure nanoparticles via an acid cleaving amide bond: the potential for magnetic targeting drug delivery. Nanotechnology. 2008;19(16): 165103.   
271. Chertok B, Mofat BA, David AE, Yu F, Bergemann C, Ross BD, et al. Iron oxide nanoparticles as a drug delivery vehicle for MRI monitored magnetic targeting of brain tumors. Biomaterials. 2008;29(4):487–96.   
272. Hutter E, Maysinger D. Gold nanoparticles and quantum dots for bioimaging. Microsc Res Tech. 2011;74(7):592–604.   
273. Saha K, Agasti SS, Kim C, Li X, Rotello VM. Gold nanoparticles in chemical and biological sensing. Chem Rev. 2012;112(5):2739–79.   
274. Zeng S, Yong K-T, Roy I, Dinh X-Q, Yu X, Luan F. A review on functionalized gold nanoparticles for biosensing applications. Plasmonics. 2011;6(3):491–506.   
275. Bhumkar DR, Joshi HM, Sastry M, Pokharkar VB. Chitosan reduced gold nanoparticles as novel carriers for transmucosal delivery of insulin. Pharm Res. 2007;24(8):1415–26.   
276. Phillips RL, Miranda OR, You C, Rotello VM, Bunz UHF. Rapid and efcient identifcation of bacteria using gold-nanoparticle–poly (para-phenyleneethynylene) constructs. Angew Chemie Int Ed. 2008;47(14):2590–4.   
277. Kairdolf BA, Qian X, Nie S. Bioconjugated nanoparticles for biosensing, in vivo imaging, and medical diagnostics. Anal Chem. 2017;89(2):1015–31.   
278. Ahmadi A, Mirzaeizadeh Z, Omidfar K. Simultaneous detection of SARS-CoV-2 IgG/IgM antibodies, using gold nanoparticles-based lateral fow immunoassay. Monoclon Antib Immunodiagn Immunother. 2021;40(5):210–8.   
279. Hajipour MJ, Fromm KM, Ashkarran AA, de Aberasturi DJ, de Larramendi IR, Rojo T, et al. Antibacterial properties of nanoparticles. Trends Biotechnol. 2012;30(10):499–511.   
280. Pant HR, Pant B, Sharma RK, Amarjargal A, Kim HJ, Park CH, et al. Antibacterial and photocatalytic properties of Ag/TiO2/ZnO nano-fowers prepared by facile one-pot hydrothermal process. Ceram Int. 2013;39(2):1503–10.   
281. Bouzigues C, Gacoin T, Alexandrou A. Biological applications of rare-earth based nanoparticles. ACS Nano. 2011;5(11):8488–505.   
282. Hifumi H, Yamaoka S, Tanimoto A, Akatsu T, Shindo Y, Honda A, et al. Dextran coated gadolinium phosphate nanoparticles for magnetic resonance tumor imaging. J Mater Chem. 2009;19(35):6393–9.   
283. Türkcan S, Masson J-B, Casanova D, Mialon G, Gacoin T, Boilot J-P, et al. Observing the confnement potential of bacterial pore-forming toxin receptors inside rafts with nonblinking Eu3+-doped oxide nanoparticles. Biophys J. 2012;102(10):2299–308.   
284. Gu L, Zhang M, He J, Ni P. A porous cross-linked gel polymer electrolyte separator for lithium-ion batteries prepared by using zinc oxide nanoparticle as a foaming agent and fller. Electrochim Acta. 2018;292:769–78.   
285. Lu Y-C, Xu Z, Gasteiger HA, Chen S, Hamad-Schiferli K, Shao-Horn Y. Platinum− gold nanoparticles: a highly active bifunctional electrocatalyst for rechargeable lithium air batteries. J Am Chem Soc. 2010;132(35):12170–1.   
286. Rodríguez-Mas F, Ferrer JC, Alonso JL, Fernández de Ávila S. Expanded electroluminescence in high load CdS nanocrystals PVK-based LEDs. Nanomaterials. 2019;9(9):1212.   
287. Qi H, Hegmann T. Impact of nanoscale particles and carbon nanotubes on current and future generations of liquid crystal displays. J Mater Chem. 2008;18(28):3288–94.   
288. Usman M, Farooq M, Wakeel A, Nawaz A, Cheema SA, Rehman H, et al. Nanotechnology in agriculture: current status, challenges and future opportunities. Sci Total Environ. 2020;721: 137778.   
289. Rameshaiah GN, Pallavi J, Shabnam S. Nano fertilizers and nano sensors—an attempt for developing smart agriculture. Int J Eng Res Gen Sci. 2015;3(1):314–20.   
290. Mastronardi E, Tsae P, Zhang X, Monreal C, DeRosa MC. Strategic role of nanotechnology in fertilizers: potential and limitations. In: Nanotechnologies in food and agriculture. Springer; 2015. p. 25–67.   
291. Changmei L, Chaoying Z, Junqiang W, Guorong W, Mingxuan T. Research of the efect of nanometer materials on germination and growth enhancement of glycine max and its mechanism. Soybean Sci. 2002;21(3):168–71.   
292. Dimkpa CO, Bindraban PS, Fugice J, Agyin-Birikorang S, Singh U, Hellums D. Composite micronutrient nanoparticles and salts decrease drought stress in soybean. Agron Sustain Dev. 2017;37(1):5.   
293. Delfani M, Baradarn Firouzabadi M, Farrokhi N, Makarian H. Some physiological responses of black-eyed pea to iron and magnesium nanofertilizers. Commun Soil Sci Plant Anal. 2014;45(4):530–40.   
294. Dikshit PK, Kumar J, Das AK, Sadhu S, Sharma S, Singh S, et al. Green synthesis of metallic nanoparticles: applications and limitations. Catalysts. 2021;11(8):902.   
295. Paret ML, Vallad GE, Averett DR, Jones JB, Olson SM. Photocatalysis: efect of light-activated nanoscale formulations of TiO2 on Xanthomonas perforans and control of bacterial spot of tomato. Phytopathology. 2013;103(3):228–36.   
296. Ayoub HA, Khairy M, Elsaid S, Rashwan FA, Abdel-Hafez HF. Pesticidal activity of nanostructured metal oxides for generation of alternative pesticide formulations. J Agric Food Chem. 2018;66(22):5491–8.   
297. Cromwell WA, Yang J, Starr JL, Jo Y-K. Nematicidal efects of silver nanoparticles on root-knot nematode in bermudagrass. J Nematol. 2014;46(3):261.   
298. Othman SH, Abd Salam NR, Zainal N, Kadir Basha R, Talib RA. Antimicrobial activity of TiO2 nanoparticle-coated flm for potential food packaging applications. Int J Photoenergy. 2014;2014:945930. https://doi.org/ 10.1155/2014/945930   
299. Cui S, Yang L, Wang J, Wang X. Fabrication of a sensitive gas sensor based on ${ \mathsf { P P y } } / { \mathsf { T i O } } _ { 2 }$ nanocomposites flms by layer-by-layer self-assembly and its application in food storage. Sensors Actuators B Chem. 2016;233:337–46.   
300. Carbone M, Donia DT, Sabbatella G, Antiochia R. Silver nanoparticles in polymeric matrices for fresh food packaging. J King Saud Univ. 2016;28(4):273–9.   
301. Mahdi SS, Vadood R, Nourdahr R. Study on the antimicrobial efect of nanosilver tray packaging of minced beef at refrigerator temperature. Glob Vet. 2012;9:284–9.   
302. Roy R, Kumar S, Tripathi A, Das M, Dwivedi PD. Interactive threats of nanoparticles to the biological system. Immunol Lett. 2014;158(1–2):79–87.   
303. Schwartz J, Litonjua A, Suh H, Verrier M, Zanobetti A, Syring M, et al. Trafc related pollution and heart rate variability in a panel of elderly subjects. Thorax. 2005;60(6):455–61.   
304. Adar SD, Gold DR, Coull BA, Schwartz J, Stone PH, Suh H. Focused exposures to airborne trafc particles and heart rate variability in the elderly. Epidemiology. 2007. https://doi.org/10.1097/01.ede.0000249409.81050. 46.   
305. Long TC, Saleh N, Tilton RD, Lowry GV, Veronesi B. Titanium dioxide (P25) produces reactive oxygen species in immortalized brain microglia (BV2): implications for nanoparticle neurotoxicity. Environ Sci Technol. 2006;40(14):4346–52.   
306. Stark WJ. Nanoparticles in biological systems. Angew Chemie Int Ed. 2011;50(6):1242–58.   
307. Lin D, Xing B. Phytotoxicity of nanoparticles: inhibition of seed germination and root growth. Environ Pollut. 2007;150(2):243–50.   
308. Yang L, Watts DJ. Particle surface characteristics may play an important role in phytotoxicity of alumina nanoparticles. Toxicol Lett. 2005;158(2):122–32.   
309. Srivastava SK, Constanti M. Room temperature biogenic synthesis of multiple nanoparticles (Ag, Pd, Fe, Rh, Ni, Ru, Pt Co, and Li) by Pseudomonas aeruginosa SM1. J Nanoparticle Res. 2012;14(4):1–10.   
310. Arya A, Gupta K, Chundawat TS, Vaya D. Biogenic synthesis of copper and silver nanoparticles using green alga Botryococcus braunii and its antimicrobial activity. Bioinorg Chem Appl. 2018. https://doi.org/10. 1155/2018/7879403.   
311. Mishra A, Ahmad R, Perwez M, Sardar M. Reusable green synthesized biomimetic magnetic nanoparticles for glucose and $H _ { 2 } O _ { 2 }$ detection. Bionanoscience. 2016;6(2):93–102.

# Publisher’s Note

Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional afliations.